#include "mbed.h"
#include "pwm_tone.h"
#include "C12832.h"

// Serial xbee1(p9, p10); //Creates a variable for serial communication through pin 9 and 10
Serial pc(USBTX, USBRX);//Opens up serial communication through the USB port via the computer
C12832 lcd (p5, p7, p6, p8, p11);
AnalogIn air(p20);
AnalogIn sensor(p17);
PwmOut spkr(p26);
PwmOut r (p23); // red light
PwmOut g (p24); // green light
PwmOut b (p25); // blue light
PwmOut Ctrl1(p21); //relay
PwmOut Ctrl2(p22); //relay
BusOut leds(LED1); // blue LED1 when air quality is low
BusIn Up(p15);
BusIn Down(p12);
BusIn Left(p13);
BusIn Right(p16);


float airValue;                       
float multiplier = 50;    // this number got us closest to the reading on the multimeter temp probe
float temp;               // calculated temperature
int count;                // for computing average reading
float total;
float average;
float max = 22;
float min = 20;
void initialize();


int main() 
{
    initialize(); 
    count = 0;
    total = 0.0;
    r = 1;
    b = 1;
    g = 1;
  
    
    while (1) {
        
        // formula is analog reading * multiplier
        airValue = air.read()* 100; // returns voltage between 0 -> 1
        temp = sensor.read() * multiplier;
        count++;
        total += temp;
        average = total / count;
        
        
           if (Up) 
        {
            
            min++;
        }
            
        if (Down)
        {
            
            min--;        
        }     
           if (Left) 
        {
            
            max--;
        }
            
        if (Right)
        {
            
            max++;        
        }   
              
                
        if(temp > max)
        {
         r = 0; // red 
         g = 1; // green
         b = 1; // blue 
         Ctrl1 = 1;
         Ctrl2 = 0;
         
         // value 0 - max
         // value 1 - zero
         // so values closer to zero 0 brighter than closer to 1
         
        }
        else
        {
         r = 1;
         g = 0.25;
         b = 1;
         Ctrl1 = 1;
         Ctrl2 = 1;
        }
        
        if(temp < min)
        {
         r = 1;
         g = 1;
         b = 0.25;
         Ctrl1 = 0;
         Ctrl2 = 1;
         
        }
        
        if (airValue > 80 )
        {
        leds =1;
        }
        
        if (airValue < 80 )
        {
        leds =0;
        }
        
        else
        {
        
        }
        
                
        lcd.cls();
        lcd.locate(0,0);
        lcd.printf("Temp= %6.2f  Avg= %5.1f ", temp  , average );
        lcd.locate(0,10);
        lcd.printf("min= %6.0f max= %6.0f", min, max);
        
        lcd.locate(0,20);
        lcd.printf("Air Quality %f \n\r",airValue);     
        
        wait(0.5); 
     
        pc.printf(" \n\r");
        pc.printf("Thermostat values\n\r");
        pc.printf("Temp= %6.2f  Avg= %5.1f \n\r", temp  , average );
        pc.printf("min= %6.0f max= %6.0f \n \r", min, max);
        pc.printf("Air Quality %f \n \r",airValue);  
        pc.printf(" \n\r");
        
        }

}

void initialize()
{
    lcd.cls();
    lcd.locate(0,0);
}
