/*
This code uses the button1 to toggle LED1 and button2 to toggle LED2 
Author: Dan M
Date Created: 12.12.2014
Last Update: 12.12.2014
*/
#include "mbed.h"
/* Define pin names and numbers (I know these probably aren't needed but I put them in to demonstrate pin numbering) */
#define LED1 p18
#define LED2 p19
#define SW1 p16
#define SW2 p17
/*Function Prototypes*/
void trigger1();//Button1 Interrupt function
void trigger2();//Button2 Interrup Function

//Instantiate IO objects
DigitalOut led_1(LED1);
DigitalOut led_2(LED2);
DigitalIn  sw_1(SW1);
DigitalIn  sw_2(SW2);
//Instantiate input interrupts
InterruptIn sw1Press(SW1);
InterruptIn sw2Press(SW2);

int main() {
    //Initialise LED output
    led_1=0;
    led_2=0;
    //Choose falling edge interrupt and connect to apppropriate interrup function
    sw1Press.fall(&trigger1);
    sw2Press.fall(&trigger2);
    while(1) {}
}
/*Button1 interrupt function*/
void trigger1()
{
 led_1=!led_1;
}
/*Button2 interrupt function*/
void trigger2()
{
 led_2=!led_2; 
}