// modes
#define MODE_ON 1
#define MODE_MANUAL 2
#define MODE_READY 4
#define MODE_TAKEOFF 8
#define MODE_STAB_ALT 16
#define MODE_STAB_PRY 32

#define ALT_METER 0.1202 //hPa per meter, t=15C
//#define ALT_METER 0.1268 //hPa per meter, t=0C
#define ALT_TRUST_ACC 40
#define ALT_P (1.0f/ALT_TRUST_ACC) // estimated altitude correction (default 0.05), 100 - due to m->cm conversion
#define ALT_ACC_I 0.0001f // ACC zero calibration (default 0.0001)
#define ALT_VEL_P 0.1f // velocity correction (default 0.1)

#define CMD_I2C_OFF 0xA0
#define CMD_I2C_ON 0xA1
#define CMD_I2C_MANUAL 0xA2
#define CMD_I2C_AUTO 0xA3
#define CMD_I2C_CTRL 0xA4

#define BAUD_RATE 19200

// nu
#define THRUST_THRESH 0.05

// delays
#define INCL_DELAY 0.002
#define CTRL_DELAY 0.02
#define MAG_DELAY 0.015
#define BAR_DELAY 0.02

#define TAKEOFF_SPEED 0.05*CTRL_DELAY // 12.5% per sec
#define TAKEOFF_LEV_ALT 0.05 // in meters 
#define TAKEOFF_CLIMB_ALT 1.0 // in meters 

// PID scales
#define ROLL_SCALE 0.01
#define PITCH_SCALE 0.01
#define YAW_SCALE 0.01
#define ALT_SCALE 0.01

// CTRL constraints
#define CTRL_DIA 511.0
#define ROLL_MAX 45.0
#define PITCH_MAX 45.0
#define YAW_MAX 90.0
#define THR_MAX 45.0
#define ALT_MAX 0.500

// altitude control blind diap
#define ALT_SPD_PE 0.005
#define ALT_SPD_NE -0.005

// sensors
#define ACC_G 9.806
#define ACC_SENS 256.0
#define ACC_SENS_INV 0.00390625
#define ACC_GS 0.0383046875
#define ACC_DEADBAND 0.3

#define GYR_SENS 0.0175

#define MAG_DECL 14.28

#define BAR_TABLE_SIZE 21

//hs battop
#define MAG_OFF {346.769036, -181.590063, -125.126453}
#define MAG_CAL {{1.924164, 0.076278, 0.027597},{0.076278, 1.997178, -0.001175},{0.027597,-0.001175,1.753297}}

// filters
#define LPFC_BAR 0.4
#define LPFC_ACC 0.02
#define LPFC_ALT 0.02

// pid roll, pitch, yaw, alt
#define PIDK {{0,0,0},{0,0,0},{0,0,0},{0,0,0}}

#define X 0
#define Y 1
#define Z 2

// roll, pitch, yaw
#define ROLL 0
#define PITCH 1
#define YAW 2
#define ALT 3

// yaw compensation direction
#define YAW_PID_DIR -1

//median filter
//#define M_FILTER
