/* Log system for internal memory flash
* Copyright (c) 2013 Oleg Evsegneev
* Released under the MIT License: http://mbed.org/license/mit
*/

#ifndef MBED_MEMLOG_H
#define MBED_MEMLOG_H
  
#include "mbed.h"

#define LOG_FILE "/local/log.txt"

class MemLog {

public:
    MemLog( short cols, short rows );

    /** Set new value to log
     *
     * @param value Value of log entry.
     */
    void log( float val );

    /**  Save log to file on flash
     *
     */
    void save();
        
protected:
    LocalFileSystem _local;
    float _data[4000];
    unsigned short _addr;
    short _cols;
    short _rows;
    short _row;
    void toArray( float val, char *bytes );
    float fromArray( char *bytes );
};

#endif