/* Log system for internal memory flash
* Copyright (c) 2013 Oleg Evsegneev
* Released under the MIT License: http://mbed.org/license/mit
*/
 
#include "mbed.h"
#include "MemLog.h"

MemLog::MemLog( short cols, short rows ): _local("local") {
    _cols = cols;
    _rows = rows;
    _addr = 0;
    _row = 0;
}

void MemLog::log( float val ) {
    if( _addr >= _rows*_cols )
        return; // can't write
    _data[_addr++] = val;
    if( ( _addr % _cols) == 0 )
        _row++;
}

void MemLog::save() {
    FILE *fp = fopen(LOG_FILE, "w");
    unsigned short addr = 0;
    
    for( short i=0; i<_row; i++){
        for( short k=0; k<_cols; k++){
            fprintf( fp, "%.4f", _data[addr++]);
            if( k < _cols-1 )
                fprintf( fp, "\t");
        }
        fprintf( fp, "\r\n");
    }
    fclose(fp);
    _addr = 0;
    _row = 0;    
}
