/* mbed ESC Library
 * Copyright (c) 2012 Oleg Evsegneev
 * Released under the MIT License: http://mbed.org/license/mit
 */

#ifndef MBED_ESC_H
#define MBED_ESC_H

#define MODE_PWM
//#define CIRC_TEST
  
#include "mbed.h"
#include "Servo.h"

class ESC {

public:

    ESC(PinName x1, PinName x2, PinName y1, PinName y2, PinName led);

    /**  Set thrust
     *
     * Sets thrust to motors
     */
     void set( float x1, float x2, float y1, float y2 );
          
    /**  Stop motors
     *
     * Sets all motor thrust to 0.0
     */
     void stop();

    /**  Initialize esc
     *
     * 1.Plug in LiPO battery
     * 2.ESC init (2sec led on)
     * 3.ESC ready (led off)
     */
     void initialize_();

    /** Calibrate esc
     * 1.Plug in external mcu power
     * 2.Plug in LiPO battery (5sec led blinking)
     * 3.ESC init (2sec led on)
     * 4.ESC ready (led off)
     */
    void calibrate_();

    /** Blink led
     */
    void blink(uint16_t delay);
        
protected:
    #ifdef MODE_PPM
    Servo _esc_x1, _esc_x2, _esc_y1, _esc_y2;
    Servo* _esca[4];
    #else
    PwmOut _esc_x1, _esc_x2, _esc_y1, _esc_y2;
    PwmOut* _esca[4];
    #endif
    DigitalOut _led;
};

#endif
