 /* Copyright (c) 2015 NXP Semiconductors. MIT License
*
* Permission is hereby granted, free of charge, to any person obtaining a copy of this software
* and associated documentation files (the "Software"), to deal in the Software without
* restriction, including without limitation the rights to use, copy, modify, merge, publish,
* distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in all copies or
* substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
* BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
* NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
* DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#include "FXAS21002.h"
#include "mbed.h"
FXAS21002::FXAS21002(PinName sda, PinName scl) : gyroi2c(sda,scl)
{
   
}

void FXAS21002::set_gyro(gyro_mode mode) // Protected method
{ 
    char d[2];
    d[0] = FXAS21002_CTRL_REG1;                       //Puts device in standby mode
    d[1] = 0x08;
    gyroi2c.write(FXAS21002_I2C_ADDRESS, d,2);

    d[0] = FXAS21002_CTRL_REG0;                       //Sets FSR and Sensitivity
    d[1] = mode + 0x80;
    gyroi2c.write(FXAS21002_I2C_ADDRESS, d, 2);

    d[0] = FXAS21002_CTRL_REG1;                       //Puts device in active mode
    d[1] = 0x0A;
    gyroi2c.write(FXAS21002_I2C_ADDRESS, d,2);
}


void FXAS21002::stop_measure(void)
{
    interrupt.detach(); 
    angle = 0;   
}

float FXAS21002::get_angle(void)
{
    return angle;
}

void FXAS21002::integrate_gyro_angle(void)
{
    float gyro_data[3];
    acquire_gyro_data_dps(gyro_data);
    
    angle = angle + (gyro_data[2]-GYRO_OFFSET)*(period/1000000);
    if(angle > 180)
        angle = angle - 360;
    if(angle < -180)
        angle = angle + 360;
}

void FXAS21002::start_measure(float period_us)
{
    period = period_us;
    interrupt.attach_us(this,&FXAS21002::integrate_gyro_angle,period);
    angle = 0;
}

void FXAS21002::gyro_config(void)
{
    set_gyro(MODE_2);           //Default implementation
    sensitivity = 0.03125;
}
 
void FXAS21002::gyro_config(gyro_mode mode)
{
    set_gyro(mode);
    switch(mode)
    {
        case MODE_1: sensitivity = 0.0625; break;
        case MODE_2: sensitivity = 0.03125; break;
        case MODE_3: sensitivity = 0.015625; break;
        case MODE_4: sensitivity = 0.0078125; break;
    }
}

void FXAS21002::acquire_gyro_data_dps(float * g_data)
{
  
    char data_bytes[7];
    gyroi2c.write(FXAS21002_I2C_ADDRESS,FXAS21002_STATUS,1,true);  // Read the 6 data bytes - LSB and MSB for X, Y and Z Axes.
    gyroi2c.read(FXAS21002_I2C_ADDRESS,data_bytes,7);

    g_data[0] =  (float)((int16_t)((data_bytes[1]*256) + (data_bytes[2]))) * sensitivity;
    g_data[1] =  (float)((int16_t)((data_bytes[3]*256) + (data_bytes[4]))) * sensitivity;
    g_data[2] =  (float)((int16_t)((data_bytes[5]*256) + (data_bytes[6]))) * sensitivity;
   
}


     
     