#ifndef __LED__
#define __LED__

#include "mbed.h"


class LED {
    private:
    	int RGB_LED_ON;                    //active Low
		int RGB_LED_OFF;                   //active Low
		int MAIN_RGB_LED_ON;                    //active HIGH	
		int MAIN_RGB_LED_OFF; 

        // Leds Objects
        DigitalOut red_led_main;
        DigitalOut green_led_main;
        DigitalOut blue_led_main;
        
        DigitalOut red_led_nxp;
        DigitalOut green_led_nxp;
        DigitalOut blue_led_nxp;


    public:
        enum{
        	BLACK,
        	RED,
        	GREEN,
        	BLUE,
            WHITE,
        	PURPLE,
        	YELLOW,
        	AQUA};
            
        LED(PinName red_main, PinName green_main, PinName blue_main, 
		    PinName red_nxp, PinName green_nxp, PinName blue_nxp);

        void set_leds_color_nxp(int color);
        void turn_leds_off_nxp();

        void set_leds_color_main(int color);
        void turn_leds_off_main();
        

};
#endif //__LED__