#include "LED.hpp"

LED::LED(PinName red_main, PinName green_main, PinName blue_main, 
		 PinName red_nxp, PinName green_nxp, PinName blue_nxp):
	red_led_main(red_main),
	green_led_main(green_main),
	blue_led_main(blue_main),
	red_led_nxp(red_nxp),
	green_led_nxp(green_nxp),
	blue_led_nxp(blue_nxp)
	{
		RGB_LED_ON = 0;                    //active Low
		RGB_LED_OFF = 1;                   //active Low
		MAIN_RGB_LED_ON = 1;                    //active HIGH	
		MAIN_RGB_LED_OFF = 0; 	
	}

void LED::turn_leds_off_nxp() {
	red_led_nxp = RGB_LED_OFF;
	green_led_nxp = RGB_LED_OFF;
	blue_led_nxp = RGB_LED_OFF;
}

void LED::set_leds_color_nxp(int color) {
	turn_leds_off_nxp();

	switch(color) {
		case RED:
			turn_leds_off_nxp();
			red_led_nxp = RGB_LED_ON;
			break;
		case GREEN:
			turn_leds_off_nxp();
			green_led_nxp = RGB_LED_ON;
			break;
		case BLUE:
			turn_leds_off_nxp();
			blue_led_nxp = RGB_LED_ON;
			break;
		case BLACK:
			turn_leds_off_nxp();
			break;
		case WHITE:
			red_led_nxp = RGB_LED_ON;
			green_led_nxp = RGB_LED_ON;
			blue_led_nxp = RGB_LED_ON;
			break;
		case PURPLE:
			turn_leds_off_nxp();
			red_led_nxp = RGB_LED_ON;
			blue_led_nxp = RGB_LED_ON;
			break;
		case YELLOW:
			turn_leds_off_nxp();
			red_led_nxp = RGB_LED_ON;
			green_led_nxp = RGB_LED_ON;
			break;
		case AQUA:
			turn_leds_off_nxp();
			blue_led_nxp = RGB_LED_ON;
			green_led_nxp = RGB_LED_ON;
			break;
		default:
			break;
	}
	
}

void LED::turn_leds_off_main() {
	red_led_main = MAIN_RGB_LED_OFF;
	green_led_main = MAIN_RGB_LED_OFF;
	blue_led_main = MAIN_RGB_LED_OFF;
}

void LED::set_leds_color_main(int color) {
	switch(color) {
		case RED:
			turn_leds_off_main();
			red_led_main = MAIN_RGB_LED_ON;
			break;
		case GREEN:
			turn_leds_off_main();
			green_led_main = MAIN_RGB_LED_ON;
			break;
		case BLUE:
			turn_leds_off_main();
			blue_led_main = MAIN_RGB_LED_ON;
			break;
		case BLACK:
			turn_leds_off_main();
			break;
		case WHITE:
			red_led_main = MAIN_RGB_LED_ON;
			green_led_main = MAIN_RGB_LED_ON;
			blue_led_main = MAIN_RGB_LED_ON;
			break;
		default:
			break;
	}
}