 /* Copyright (c) 2015 NXP Semiconductors. MIT License
*
* Permission is hereby granted, free of charge, to any person obtaining a copy of this software
* and associated documentation files (the "Software"), to deal in the Software without
* restriction, including without limitation the rights to use, copy, modify, merge, publish,
* distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in all copies or
* substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
* BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
* NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
* DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#ifndef FXAS21002_H
#define FXAS21002_H
#include "mbed.h"

#define FXAS21002_I2C_ADDRESS 0x40

#define FXAS21002_STATUS 0x00
#define FXAS21002_WHO_AM_I 0x0C
#define FXAS21002_CTRL_REG0 0x0D
#define FXAS21002_CTRL_REG1 0x13
#define FXAS21002_WHO_AM_I_VALUE 0xD1
#define GYRO_OFFSET -0.239 //-0.15 //-0.2396875
/*  Gyroscope mechanical modes
*   Mode    Full-scale range [Deg/s]    Sensitivity [(mDeg/s)/LSB]
*   1       +- 2000                     62.5
*   2       +- 1000                     31.25
*   3       +- 500                      15.625
*   4       +- 250                      7.8125
*/
enum gyro_mode
{
    MODE_1 = 0x00, 
    MODE_2 = 0x01,
    MODE_3 = 0x02,
    MODE_4 = 0x03
};

class FXAS21002
{
    public:
    
    FXAS21002(PinName sda, PinName scl);
      
    void gyro_config(void);
    void gyro_config(gyro_mode mode);
        
    void acquire_gyro_data_dps(float * du);
    void start_measure(float period_us);
    void stop_measure(void);
    float get_angle(void);
    
    private:
    void set_gyro(gyro_mode mode);
    void integrate_gyro_angle(void);
    Ticker interrupt;
    I2C gyroi2c;
    float sensitivity;
    float angle;
    float period;
    
};

#endif