/**
@file receiver.h
@brief Receiver side functions declarations.
*/

/*
Copyright 2016 Erik Perillo <erik.perillo@gmail.com>

This file is part of piranha-ptc.

This is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this. If not, see <http://www.gnu.org/licenses/>.
*/


#ifndef __PIRANHA_RCV_PROTOCOL_H__
#define __PIRANHA_RCV_PROTOCOL_H__

#include "protocol.h"
#include "mbed.h"
#include "EthernetInterface.h"

#define TEST

class Receiver
{
        
	#ifdef TEST
	public:
	#else
	protected:
	#endif
	UDPSocket sock;
	char message[MSG_BUF_LEN];
	Endpoint sender_addr;	

	float un_scale(uint16_t value, float min, float max);
	uint8_t get_header();
	uint16_t get_raw_val(int pos=0);
	float get_val(float min, float max, int pos=0);
	void get_vals(float min, float max, float* vals, int size);

	public:
	Receiver();
	Receiver(Endpoint sender_addr, const UDPSocket& sock);
	Receiver(Endpoint sender_addr, int sock_port=RECEIVER_PORT, int timeout=1);

	void set_sender_addr(const Endpoint& sender_addr);
	void set_socket(const UDPSocket& sock);
	void set_socket(int port=RECEIVER_PORT, int timeout=1);
	Endpoint get_sender_addr();
	UDPSocket get_socket();

	bool receive();
	uint8_t get_msg();
	float get_abs_ang_ref();
	float get_rel_ang_ref();
	float get_mag_ang_ref();
	float get_gnd_vel();
	void get_brake(float* intensity, float* period);
	void get_jog_vel(float* period, float* ratio);
	void get_pid_params(float* params);
	void get_mag_calib(float* params);
};

#endif

