#ifndef MOTOR_HEADER
#define MOTOR_HEADER

#include "mbed.h"
#include "CarPWM.h"

class Motor{
    
    protected:
    Ticker interruption;
    bool alternate_motor;
    float velocity;
    float jog_duty_cycle;
    float jog_period;
    PwmOut motor;

public:
    
    void startJogging(float jog_dc, float jog_p);
    void stopJogging(void);
    void brakeMotor(float brake_intensity, float brake_wait);
    void reverseMotor(int speed);
    void setVelocity(int new_velocity);
    float getVelocity();
    void setSmoothVelocity(int new_velocity);
    Motor(): motor(PTC3){}
    
private:
     void motorJogging(void);
     
};
#endif