#include "CarPWM.h"
#include "mbed.h"

#define MINIMUM_MOTOR_WIDTH 1160 // microseconds
#define ZERO_MOTOR_WIDTH 1505    // microseconds
#define MAXIMUM_MOTOR_WIDTH 1910 // microseconds
#define MINIMUM_SERVO_WIDTH 1016 // microseconds
#define ZERO_SERVO_WIDTH 1470    // microseconds
#define MAXIMUM_SERVO_WIDTH 1858 // microseconds
#define PERIOD 13500             // miliseconds
#define MOTOR_RANGE_MAX 100
#define SERVO_ANGLE_MAX 100

void initialize(PwmOut motor, PwmOut servo){
    motor.period_us(PERIOD);
    servo.period_us(PERIOD);
    }
void setServoPWM(float angle, PwmOut servo){
    if(angle > SERVO_ANGLE_MAX)
        angle = SERVO_ANGLE_MAX;
    else if(angle < -SERVO_ANGLE_MAX)
        angle = - SERVO_ANGLE_MAX;
    float servo_width = ZERO_SERVO_WIDTH + (angle/SERVO_ANGLE_MAX)*(MAXIMUM_SERVO_WIDTH - ZERO_SERVO_WIDTH); 
    servo.pulsewidth_us(servo_width);
   // Serial pc(USBTX, USBRX);
   // pc.printf("\nServo: %f ",servo_width);
}
void setMotorPWM(float speed, PwmOut motor){
    if(speed > MOTOR_RANGE_MAX)
        speed = MOTOR_RANGE_MAX;
    else if(speed < -MOTOR_RANGE_MAX)
        speed = - MOTOR_RANGE_MAX;
    float motor_speed = ZERO_MOTOR_WIDTH + (speed/MOTOR_RANGE_MAX)*(MAXIMUM_MOTOR_WIDTH - ZERO_MOTOR_WIDTH); 
    motor.pulsewidth_us(motor_speed);
  //  Serial pc(USBTX, USBRX);
  //  pc.printf("Motor: %f ",motor_speed);

}