#include <stdio.h>
#include "jtagPinState.h"

/*
class jtagPinState {

    bool TDI, TDO, TCK, TMS, TRST, CAPTURE_TDO;
    public:
        jtagPinState();   // Constructor
        jtagPinState(int,int,int,int,int,int);
        
        void tdi(bool val) { TDI = val; }
        bool tdi() { return TDI; }

        void tdo(bool val) { TDO = val; }
        bool tdo() { return TDO; }

        void tck(bool val) { TCK = val; }
        bool tck() { return TCK; }

        void tms(bool val) { TMS = val; }
        bool tms() { return TMS; }

        void trst(bool val) { TRST = val; }
        bool trst() { return TRST; }

        void capture_tdo(bool val) { CAPTURE_TDO = val; }
        bool capture_tdo() { return CAPTURE_TDO; }
    
        void tdata(int tdataARR[]);
        void tdata(int, int, int, int, int, int);
        void tdata(bool tdataARR[6]) { TDI = tdataARR[5]; TDO = tdataARR[4]; TCK = tdataARR[3]; TMS = tdataARR[2]; TRST = tdataARR[1]; CAPTURE_TDO = tdataARR[0]; }
        bool * tdata() { bool tdataARR[6]; tdataARR[5] = TDI; tdataARR[4] = TDO; tdataARR[3] = TCK; tdataARR[2] = TMS; tdataARR[1] = TRST; tdataARR[0] = CAPTURE_TDO; return tdataARR; }
        
        void print(void) { printf("\n\rjtagPinState:  %0d%0d%0d%0d%0d%0d.", TDI, TDO, TCK, TMS, TRST, CAPTURE_TDO); }
};
*/
//  Constructors
jtagPinState::jtagPinState(void) {
    TDI = false;
    TDO = false;
    TCK = false;
    TMS = false;
    TRST = false;
    CAPTURE_TDO = false;
}
jtagPinState::jtagPinState(int tdi, int tdo, int tck, int tms, int trst, int capture_tdo) {
    TDI = tdi;
    TDO = tdo;
    TCK = tck;
    TMS = tms;
    TRST = trst;
    CAPTURE_TDO = capture_tdo;
}
        
void jtagPinState::tdi(bool val) { TDI = val; }
bool jtagPinState::tdi() { return TDI; }

void jtagPinState::tdo(bool val) { TDO = val; }
bool jtagPinState::tdo() { return TDO; }

void jtagPinState::tck(bool val) { TCK = val; }
bool jtagPinState::tck() { return TCK; }

void jtagPinState::tms(bool val) { TMS = val; }
bool jtagPinState::tms() { return TMS; }

void jtagPinState::trst(bool val) { TRST = val; }
bool jtagPinState::trst() { return TRST; }

void jtagPinState::capture_tdo(bool val) { CAPTURE_TDO = val; }
bool jtagPinState::capture_tdo() { return CAPTURE_TDO; }

void jtagPinState::tdata(int tdi, int tdo, int tck,  int tms, int trst, int capture_tdo) {
    if (tdi) {
        TDI = true;
    } else {
        TDI = false;
    }
    if (tdo) {
        TDO = true;
    } else {
        TDO = false;
    }
    if (tck) {
        TCK = true;
    } else {
        TCK = false;
    }
    if (tms) {
        TMS = true;
    } else {
        TMS = false;
    }
    if (trst) {
        TRST = true;
    } else {
        TRST = false;
    }
    if (capture_tdo) {
        CAPTURE_TDO = true;
    } else {
        CAPTURE_TDO = false;
    }
}

void jtagPinState::tdata(int tdataARR[]) {

    if (tdataARR[5]) {
        TDI = true;
    } else {
        TDI = false;
    }
    if (tdataARR[4]) {
        TDO = true;
    } else {
        TDO = false;
    }
    if (tdataARR[3]) {
        TCK = true;
    } else {
        TCK = false;
    }
    if (tdataARR[2]) {
        TMS = true;
    } else {
        TMS = false;
    }
    if (tdataARR[1]) {
        TRST = true;
    } else {
        TRST = false;
    }
    if (tdataARR[0]) {
        CAPTURE_TDO = true;
    } else {
        CAPTURE_TDO = false;
    }
}

void jtagPinState::tdata(bool tdataARR[6]) { TDI = tdataARR[5]; TDO = tdataARR[4]; TCK = tdataARR[3]; TMS = tdataARR[2]; TRST = tdataARR[1]; CAPTURE_TDO = tdataARR[0]; }
bool * jtagPinState::tdata() { bool tdataARR[6]; tdataARR[5] = TDI; tdataARR[4] = TDO; tdataARR[3] = TCK; tdataARR[2] = TMS; tdataARR[1] = TRST; tdataARR[0] = CAPTURE_TDO; return tdataARR; }
        
void jtagPinState::print(void) { printf("\n\rjtagPinState:  %0d%0d%0d%0d%0d%0d.", TDI, TDO, TCK, TMS, TRST, CAPTURE_TDO); }
