//-------------------------------------------------------------------------------
// 
//  Treehouse Designs Inc.
//  Colorado Springs, Colorado
// 
//  Copyright (c) 2016 by Treehouse Designs Inc. 
//  Copyright (c) 2018 by Agility Power Systems Inc. 
// 
//  This code is the property of Treehouse Designs, Inc. (Treehouse) and
//  Agility Power Systems Inc. (Agility) and may not be redistributed
//  in any form without prior written permission from 
//  both copyright holders, Treehouse and Agility.
//
//  The above copyright notice and this permission notice shall be included in
//  all copies or substantial portions of the Software.
// 
//   
//-------------------------------------------------------------------------------
// 
//  REVISION HISTORY:
//  
//   $Author: $
//   $Rev: $
//   $Date: $
//   $URL: $
// 
//-------------------------------------------------------------------------------

#ifndef ADC_DEFS_H
#define ADC_DEFS_H

#include "parameters.h"

const unsigned int ADC_SCALE_FACTOR = ADC_MAX_VALUE/2;

#define VOLTAGE_TARG_VALUE 1.65/*
#define VOLTAGE_48_ACTUAL_VALUE 1.51
#define VOLTAGE_24_ACTUAL_VALUE 1.55
#define VOLTAGE_12_ACTUAL_VALUE 1.53*/
extern double VOLTAGE_48_ACTUAL_VALUE;
extern double VOLTAGE_24_ACTUAL_VALUE;
extern double VOLTAGE_12_ACTUAL_VALUE;
extern double VOLTAGE_48_OFFSET;
extern double VOLTAGE_24_OFFSET;
extern double VOLTAGE_12_OFFSET;
extern double VOLTAGE_48_CORRECTION;
extern double VOLTAGE_24_CORRECTION;
extern double VOLTAGE_12_CORRECTION;
extern double VOLTAGE_48_FACTOR;
extern double VOLTAGE_24_FACTOR;
extern double VOLTAGE_12_FACTOR;

/*
#define CURRENT_48_DIV_FACTOR5 -370
#define CURRENT_48_DIV_FACTOR4 -570
#define CURRENT_48_DIV_FACTOR3 -740
#define CURRENT_48_DIV_FACTOR2 -948
#define CURRENT_48_DIV_FACTOR1 -1541
#define CURRENT_48_DIV_FACTOR0 -1610

#define CURRENT_48_DIV_THRESH5 3000
#define CURRENT_48_DIV_THRESH4 2500
#define CURRENT_48_DIV_THRESH3 2000
#define CURRENT_48_DIV_THRESH2 1500
#define CURRENT_48_DIV_THRESH1 500

#define CURRENT_24_DIV_FACTOR -376

#define CURRENT_12_DIV_FACTOR5 -188
#define CURRENT_12_DIV_FACTOR4 -186
#define CURRENT_12_DIV_FACTOR3 -182
#define CURRENT_12_DIV_FACTOR2 -177
#define CURRENT_12_DIV_FACTOR1 -179
#define CURRENT_12_DIV_FACTOR0 -175

#define CURRENT_12_DIV_THRESH5 1600
#define CURRENT_12_DIV_THRESH4 800
#define CURRENT_12_DIV_THRESH3 600
#define CURRENT_12_DIV_THRESH2 400
#define CURRENT_12_DIV_THRESH1 200
*/
extern signed int CURRENT_48_DIV_FACTOR5;
extern signed int CURRENT_48_DIV_FACTOR4;
extern signed int CURRENT_48_DIV_FACTOR3;
extern signed int CURRENT_48_DIV_FACTOR2;
extern signed int CURRENT_48_DIV_FACTOR1;
extern signed int CURRENT_48_DIV_FACTOR0;

extern unsigned int CURRENT_48_DIV_THRESH5;
extern unsigned int CURRENT_48_DIV_THRESH4;
extern unsigned int CURRENT_48_DIV_THRESH3;
extern unsigned int CURRENT_48_DIV_THRESH2;
extern unsigned int CURRENT_48_DIV_THRESH1;

extern signed int CURRENT_24_DIV_FACTOR;

extern signed int CURRENT_12_DIV_FACTOR5;
extern signed int CURRENT_12_DIV_FACTOR4;
extern signed int CURRENT_12_DIV_FACTOR3;
extern signed int CURRENT_12_DIV_FACTOR2;
extern signed int CURRENT_12_DIV_FACTOR1;
extern signed int CURRENT_12_DIV_FACTOR0;

extern unsigned int CURRENT_12_DIV_THRESH5;
extern unsigned int CURRENT_12_DIV_THRESH4;
extern unsigned int CURRENT_12_DIV_THRESH3;
extern unsigned int CURRENT_12_DIV_THRESH2;
extern unsigned int CURRENT_12_DIV_THRESH1;


extern double CURRENT_48_CORRECTION0;
extern double CURRENT_48_CORRECTION1;
extern double CURRENT_48_CORRECTION2;
extern double CURRENT_48_CORRECTION3;
extern double CURRENT_48_CORRECTION4;
extern double CURRENT_48_CORRECTION5;
extern double CURRENT_12_CORRECTION0;
extern double CURRENT_12_CORRECTION1;
extern double CURRENT_12_CORRECTION2;
extern double CURRENT_12_CORRECTION3;
extern double CURRENT_12_CORRECTION4;
extern double CURRENT_12_CORRECTION5;

//const double ROW_CORRECTION_FACTOR = 1.017; // 2.6W/chip avg.
const double ROW_CORRECTION_FACTOR = 0.85; // 3W/chip avg.
#define ROW_HYSTERESIS 1

extern double CURRENT_48_OFFSET;
extern double CURRENT_24_OFFSET;
extern double CURRENT_12_OFFSET;

#endif