#include "mbed.h"
#include "serial.h"
#include "stdio.h"
#include "string.h"
#include "globals.h"
#include "all_io.h"

/************* GLOBAL VARIABLES *****************************/
struct serialStatusBits serialStatus;
char strbuf[150] = {0};
char rxbuf[MAXRXBUF+1] = {0};
volatile unsigned int bufloc = 0;

/************* FORWARD DECLARATIONS *************************/
void Rx_IRQHandler(void);


// set up serial port for 115200 baud
Serial dcm1(USBTX, USBRX, 921600);


// initialize the serial port variables
void initSerial(void)
{
   // create the RxIRQ callback
   dcm1.attach(&Rx_IRQHandler, Serial::RxIrq);
   
}
   

// this is the interrupt request handler (IRQ) for ALL Recoev interrupts
void Rx_IRQHandler(void)
{
   // reinit the repeat flag
   serialStatus.repeat = FALSE;

   // check if the USART1 receive interrupt flag was set
   while (dcm1.readable())
   {
      rxbuf[bufloc] = dcm1.getc();

      if (rxbuf[bufloc] == CR)        // check for end of command
      {
         serialStatus.command = TRUE;
         rxbuf[bufloc] = 0;
         bufloc = 0;
         return;
      }
      else if (rxbuf[bufloc] == '$')  // check for computer command
      {
         serialStatus.computer = TRUE;
         bufloc = 0; // reset the buffer if computer command
      }
      else if (rxbuf[bufloc] == ')')  // check for repeat command
      {
         serialStatus.repeat = TRUE;
         rxbuf[bufloc] = 0;
      }

      // Echo character back out the serial port
      if (!serialStatus.computer)
      {
         dcm1.putc((unsigned char)rxbuf[bufloc]);
      }

      // handle backspace
      if (rxbuf[bufloc] != 0x08)
      {
         bufloc++; // increment the location
      }
      else
      {
         if (bufloc > 0)
         {
            rxbuf[--bufloc] = 0;  // set to null
         }
         else
         {
            rxbuf[bufloc] = 0;  // set to null
         }
      }
      
      // check for overflow
      if (bufloc >= MAXRXBUF)
      {
         bufloc = 0;
         rxbuf[0] = 0;
      }
      
     
   }
}



// send buffer to the serial port
void sendSerial(char *buf)
{
    dcm1.printf(buf);
}

/************************************************************
* Routine: showRangeError
* Input:   error -- 0 = in range, 1 = out of range
* Output:  none
* Description:
* Sends a floating point number (value) over the serial port
* if it is being retrieved (GET)
*
**************************************************************/
void showRangeError(int intValue, int iBadValue, float fBadValue)
{
   if (intValue){ 
      sprintf(strbuf, " Out of Range: %d",    iBadValue);
   }else{
      sprintf(strbuf, " Out of Range: %0.3f", fBadValue);
   }

   sendSerial(strbuf);
}
 