//-------------------------------------------------------------------------------
// 
//  Treehouse Designs Inc.
//  Colorado Springs, Colorado
// 
//  Copyright (c) 2018 by Treehouse Designs Inc. 
//  Copyright (c) 2018 by Agility Power Systems Inc. 
// 
//  This code is the property of Treehouse Designs, Inc. (Treehouse) and
//  Agility Power Systems Inc. (Agility) and may not be redistributed
//  in any form without prior written permission from 
//  both copyright holders, Treehouse and Agility.
//
//  The above copyright notice and this permission notice shall be included in
//  all copies or substantial portions of the Software.
// 
//   
//-------------------------------------------------------------------------------
// 
//  REVISION HISTORY:
//  
//   $Author: $
//   $Rev: $
//   $Date: $
//   $URL: $
// 
//-------------------------------------------------------------------------------

#include "mbed.h"
#include "all_io.h"
#include "PortOut.h"

// Digital IO
//
// Slots 12 to 0 are activated with the wr_out signals
// wr_out[13] = slots[12:0]
// BusOut signals are specified LSB first
BusOut wr_out(PA_10, PA_11, PA_12, PA_13, PA_14, PA_15, PC_6, PC_7, PC_8, PC_9, PC_10, PC_11, PC_12); //RK: Need to change ADC inputs to PC_0-PC_5

// en_out are binary weighted signals that activate groups of DC-DC converters on the slot cards.
// en_out[6] = {en32, en16, en8, en4, en2, en1}
//BusOut en_out(PA_9, PA_8, PA_7, PA_6, PC_14, PA_4); //RK: debug 11/26/2018
//BusOut signals are specified LSB first
BusOut en_out(PA_4, PC_13, PA_6, PA_7, PA_8, PA_9);
DigitalIn pc14(PC_14);


// Expansion port signals
// eport[16] = eport[18:3]
DigitalIn  eport[16] = {PB_15, PB_14, PB_13, PB_12, PC_15, PB_10, PB_9, PB_8, PB_7, PB_6, PB_5, PB_4, PB_3, PB_2, PB_1, PB_0}; //RK 11/24/2018 PB_11 throws an error. Identifier "PB_11" is undefined. PB_11 is connected to VCAP1.

// Use extchlat to latch new wr_out signals to the external slots via ribbon cable.
DigitalOut extchlat(PA_1);

// all_on indicates that the load demanded a high amount of current and all DC-DC converters are enabled.
DigitalIn  all_on(PA_0);

// Analog IO
//
AnalogIn VIN48(PC_3);
AnalogIn VIN24(PC_4);
AnalogIn VIN12(PC_5);
AnalogIn IIN48(PC_2);
AnalogIn IIN24(PC_1);
AnalogIn IIN12(PC_0);

DigitalOut myled(LED1);
