#ifndef SERIAL_H
#define SERIAL_H

#include "mbed.h"

#define MAXRXBUF 80
#define CR 0x0d

extern struct serialStatusBits serialStatus;

struct serialStatusBits
{
  unsigned int command:1;   // command available flag
  unsigned int repeat:1;    // repeat flag
  unsigned int computer:1;  // computer flag
  unsigned int command2:1;   // command available flag on serial 2
  unsigned int spare:12;
};

extern char strbuf[150];
extern char rxbuf[MAXRXBUF+1];
extern volatile unsigned int bufloc;
extern Serial pc;

void initSerial(void);
void sendSerial(char *buf);
void sendCRLF(void);
void showRangeError(int , int , float );

#endif