//-------------------------------------------------------------------------------
// 
//  Treehouse Designs Inc.
//  Colorado Springs, Colorado
// 
//  Copyright (c) 2016 by Treehouse Designs Inc. 
//  Copyright (c) 2018 by Agility Power Systems Inc. 
// 
//  This code is the property of Treehouse Designs, Inc. (Treehouse) and
//  Agility Power Systems Inc. (Agility) and may not be redistributed
//  in any form without prior written permission from 
//  both copyright holders, Treehouse and Agility.
//
//  The above copyright notice and this permission notice shall be included in
//  all copies or substantial portions of the Software.
// 
//   
//-------------------------------------------------------------------------------
// 
//  REVISION HISTORY:
//  
//   $Author: $
//   $Rev: $
//   $Date: $
//   $URL: $
// 
//-------------------------------------------------------------------------------

#include "mbed.h"
#include "th_rtz.h"

// Master Pins
#ifdef IS_MASTER
DigitalOut Mstr_Tx1(PB_6);
DigitalOut Mstr_Tx2(PB_7);
#endif
// Slave Pins
#ifdef IS_SLAVE
InterruptIn Slave_Rx1(PB_6);
InterruptIn Slave_Rx2(PB_7);
#endif

Timer rxS; //Timer used for timing pulses on Slave_Rx

Timer rxTO; //used for timeout if receive pulses never arrive

volatile unsigned int Slave_Rx_pulseTime = 0;

//////////////////////////////////////////////////////////////////
void Slave_Rx_riseIRQ(void){
    rxS.stop();
    Slave_Rx_pulseTime = rxS.read_us();
    pulseReady = true;
}

//////////////////////////////////////////////////////////////////
void Slave_Rx_fallIRQ(void){
    rxS.stop();
    rxS.reset();
    rxS.start();
    Slave_Rx_pulseTime = 0;
}

//////////////////////////////////////////////////////////////////
void Slave_Init(void){
    #ifdef IS_SLAVE
    if(slave1){
        Slave_Rx1.rise(&Slave_Rx_riseIRQ);
        Slave_Rx1.fall(&Slave_Rx_fallIRQ);
    }else if(slave2){
        Slave_Rx2.rise(&Slave_Rx_riseIRQ);
        Slave_Rx2.fall(&Slave_Rx_fallIRQ);
    }
    #endif
}

//////////////////////////////////////////////////////////////////
unsigned short Slave_RXstr(void){
    
    int rxBits = 8;
    //char Slave_Rx_pulseTimeStr[10];
    unsigned short rxData = 0;
    
    rxTO.reset();
    rxTO.start(); //start timeout counter
    
    while(rxBits > 0){
        
        if(pulseReady){
            rxTO.reset(); //reset timeout counter
            pulseReady = false;
            rxBits--;
            if(Slave_Rx_pulseTime > 25 & Slave_Rx_pulseTime < 100){
                rxData << 1;
            } else if(Slave_Rx_pulseTime > 125 & Slave_Rx_pulseTime < 200){
                rxData++;
                rxData << 1;
            }else{// start of sequence or invalid bit
                rxData = 0;
                //responseStr += "[bit time = ";
                //sprintf(Slave_Rx_pulseTimeStr, "%d", Slave_Rx_pulseTime);
                //responseStr += string(Slave_Rx_pulseTimeStr);
                //responseStr += "] ";
            }    
        }else if(rxTO.read_us() > RX_TIMEOUT){
            rxTO.stop();
            //responseStr += "RX timeout";
            break;
        }//end if(pulseReady
    }//end while
    
    return rxData;
}

//////////////////////////////////////////////////////////////////
void sendMstr_one(unsigned short slaveNum){
    #ifdef IS_MASTER
    if(slaveNum == 1){
        Mstr_Tx1 = 0;  //send data is inverted due to open-drain outputs
        wait_us(150);
        Mstr_Tx1 = 1;
        wait_us(150);
    }else if(slaveNum == 2){
        Mstr_Tx2 = 0;  //send data is inverted due to open-drain outputs
        wait_us(150);
        Mstr_Tx2 = 1;
        wait_us(150);
    }
    #endif
}

//////////////////////////////////////////////////////////////////
void sendMstr_zero(unsigned short slaveNum){
    #ifdef IS_MASTER
    if(slaveNum == 1){
        Mstr_Tx1 = 0;  //send data is inverted due to open-drain outputs
        wait_us(50);
        Mstr_Tx1 = 1;
        wait_us(250);
    }else if(slaveNum == 2){
        Mstr_Tx2 = 0;  //send data is inverted due to open-drain outputs
        wait_us(50);
        Mstr_Tx2 = 1;
        wait_us(250);
    }
    #endif
}

//////////////////////////////////////////////////////////////////
void sendByte(unsigned short slaveNum, char data_byte){
    
    for(unsigned short i=0;i<8;i++){
        if(data_byte == 1){ //Had to change from if(databyte[i]){ in order to compile
            sendMstr_one(slaveNum);
        }else{
            sendMstr_zero(slaveNum);
        }
    }
}

//////////////////////////////////////////////////////////////////
void sendPreamble(void){
    //Send  = 0x88
    unsigned short slaveNum = 1;
    sendMstr_one(slaveNum); //All fields were empty. Supplied filler
    sendMstr_zero(slaveNum);
    sendMstr_zero(slaveNum);
    sendMstr_zero(slaveNum);
    
    sendMstr_one(slaveNum);
    sendMstr_zero(slaveNum);
    sendMstr_zero(slaveNum);
    sendMstr_zero(slaveNum);
}

