//-------------------------------------------------------------------------------
// 
//  Treehouse Designs Inc.
//  Colorado Springs, Colorado
// 
//  Copyright (c) 2018 by Treehouse Designs Inc. 
//  Copyright (c) 2018 by Agility Power Systems Inc. 
// 
//  This code is the property of Treehouse Designs, Inc. (Treehouse) and
//  Agility Power Systems Inc. (Agility) and may not be redistributed
//  in any form without prior written permission from 
//  both copyright holders, Treehouse and Agility.
//
//  The above copyright notice and this permission notice shall be included in
//  all copies or substantial portions of the Software.
// 
//   
//-------------------------------------------------------------------------------
// 
//  REVISION HISTORY:
//  
//   $Author: $
//   $Rev: $
//   $Date: $
//   $URL: $
// 
//-------------------------------------------------------------------------------

#include "mbed.h"
#include "math.h"
#include "globals.h"
#include "parameters.h"
#include "all_io.h"
#include "stdio.h"
#include "stdlib.h"
#include "serial.h"
#include "adc.h"
#include "adc_defs.h"
#include "menu.h"
#include "boards.h"
#include "command.h"
#include "clocks.h"
#include "th_rtz.h"

#define IS_MASTER
//#define IS_SLAVE

//DigitalOut myled(LED1);
Ticker slowClk;
Ticker fastClk;

unsigned short my12=0;
volatile bool updateReady = FALSE;
volatile bool pulseReady = FALSE;
unsigned int loopTime = 0;
bool raw = FALSE;
bool running = FALSE;
bool testing = FALSE;
bool buck = TRUE;
bool pcConnected = FALSE;   //New for 1U5
bool master = FALSE;        //New for 1U5
bool slave1 = FALSE;        //New for 1U5
bool slave2 = FALSE;        //New for 1U5

unsigned int max_rows = 2048;
unsigned int bCodeRow[13];
unsigned short max_boards = 3;
unsigned short row = 0;
short row_test = 0;
unsigned short slave_code = 0;
unsigned short new_slave_code = 0;

double CURRENT_48_OFFSET = 33940;
double CURRENT_24_OFFSET = 33580;
double CURRENT_12_OFFSET = 33256;

unsigned int temperatureVal;

//void fastFlip(unsigned short numFast){
//    if(numFast >= 1){ec0 = ~ec0;}
//    if(numFast >= 2){ec1 = ~ec1;}
//    ...
//    if(numFast >= 36){ec35 = ~ec35;}
//}

//void slowFlip(unsigned short numFast){
//    numSlow = MAX_CHIPS - numFast;
//    if( numSlow  >= 36){ec35 = ~ec35;}else{return;}
//    if( numSlow  >= 35){ec34 = ~ec34;}else{return;}
//    ...
//    if( numSlow  >= 1){ec0 = ~ec0;}
//}



int main() {    
    
    if(MS){ //New for 1U5
        #ifdef IS_MASTER
          master = TRUE;
        #endif
        #ifdef IS_SLAVE
          slave1 = TRUE;
          slave2 = FALSE;
        #endif
    }else{
        #ifdef IS_SLAVE
          slave1 = FALSE;
          slave2 = TRUE;
        #endif
    }
    
    Slave_Init();
    
    initOut();
    
    slowClk.attach_us(&slowFlip, CLK_SLOW);
    fastClk.attach_us(&fastFlip, CLK_FAST);
    ILR_enable.rise(&ILR);

    running = FALSE;
   
    initSerial();
    
    initI2C();
    
    initDRT(); // Display Refresh Timer
   
    initADC();

    struct adcValues adcVals = getADCresults();
    struct displayValues dispVals = calcDisplayValues(adcVals);
    struct statusValues statVals = checkLevels(adcVals);
   
    row = (unsigned short)(dispVals.i12f*dispVals.v12f*ROW_CORRECTION_FACTOR);
    unsigned int old_row = row;
   
    menu_banner();
    sprintf(strbuf, "\r\nPress Enter to continue");
    sendSerial(strbuf);
    //while(waitCommand()){ // Wait for user to press Enter
    //}
   
    menuRedraw(WITH_PROMPT);
   
    initBoards(adcVals);

    while (1)
    {
      #ifdef IS_MASTER
      
      adcVals = getADCresults();
        
      temperatureVal = getTEMPERATUREresults();
      setFan(temperatureVal);
      
      dispVals = calcDisplayValues(adcVals);
      
      statVals = checkLevels(adcVals);
      
      processCommand();
      
      // Select RUN from menu to activate running mode.
      // BRDS, MULT activate testing mode. MY12 emulates running mode wthout being in running mode.
      // CAL and UNCAL do not change state of running or testing.
      if(adcVals.i12 < CURRENT_12_OFFSET){    
            row = (unsigned short)(dispVals.i12f*dispVals.v12f*ROW_CORRECTION_FACTOR);
            buck = TRUE;
      }else{
            row = (unsigned short)(dispVals.i12f*dispVals.v12f*(-ROW_CORRECTION_FACTOR));
            buck = FALSE;
      }
      row_test = abs((int)(row-old_row));
      
      if(updateReady && pcConnected){
         updateReady = FALSE;
         updateTerminal(adcVals, statVals);  // May want to gate this call when we run a headless system.

      }
      #endif
      
      checkFlip();
      if(running && master){ //New for 1U5
          //The current sensors results are single-ended. Results below the midpoint are for buck mode, above is for boost mode.
            if(row_test>ROW_HYSTERESIS){
                old_row = row;
                if(row<=1023){
                    slave_code = updateMasterControls(row);    //New for 1U5
                    sendSlaveCommands(slave_code);  //New for 1U5
                }
            }
      else if(running && !master){  //New for 1U5
            new_slave_code = getMasterCommands();    //New for 1U5
            if(new_slave_code != slave_code){
                slave_code = new_slave_code;
                updateSlaveControls(slave_code);     //New for 1U5
            }
        }
      }else if(!testing){
          row_test = abs((int)(my12-old_row));
          if(row_test>ROW_HYSTERESIS){
             old_row = my12;
             if(row<=1023){
                 updateMasterControls(my12);
             }
          }
          numFast = 36;
      }
    }//end while(1)
}//end void main(void)