//-------------------------------------------------------------------------------
// 
//  Treehouse Designs Inc.
//  Colorado Springs, Colorado
// 
//  Copyright (c) 2016 by Treehouse Designs Inc. 
//  Copyright (c) 2018 by Agility Power Systems Inc. 
// 
//  This code is the property of Treehouse Designs, Inc. (Treehouse) and
//  Agility Power Systems Inc. (Agility) and may not be redistributed
//  in any form without prior written permission from 
//  both copyright holders, Treehouse and Agility.
//
//  The above copyright notice and this permission notice shall be included in
//  all copies or substantial portions of the Software.
// 
//   
//-------------------------------------------------------------------------------
// 
//  REVISION HISTORY:
//  
//   $Author: $
//   $Rev: $
//   $Date: $
//   $URL: $
// 
//-------------------------------------------------------------------------------

#include "mbed.h"
#include "stdint.h"
#include "globals.h"
#include "lut.h"
#include "clocks.h"

unsigned int binCode[WEIGHT_BIN_WIDTH+1];
unsigned int thermCode[BOARDS_THERMCODE_WIDTH+1];

#include "lut_data_numFast_v1p0_1.h"
#include "lut_data_slot_v1p5_1.h"

#include "lut_data_en_v1p5_2.h"
#include "lut_data_slot_v1p5_2.h"

/*******************************************************************************
getLUT_binCodeArray - gets output codes from LUT using row reference.
*******************************************************************************/
void getLUT_binCodeArray(unsigned short row){
    short marker = row;
    if(row <=92){
        numFast = binC_1[row];
    }else{
        numFast = 36;
    }
    for(unsigned int b=0;b<max_boards;b++){
        if(marker<=0){
            bCodeRow[b] = 0;
        
        }else if(marker>MAX_LUT_ENTRIES_1){
            bCodeRow[b] = 32;
        
        }else{
            bCodeRow[b] = binC_1[marker];
        }
        marker = marker - 94;
    }
}


/*******************************************************************************
getLUT_binCode - gets output codes from LUT using row reference.
*******************************************************************************/
unsigned int getLUT_thermCode(unsigned short row){
    unsigned int thermC;
    unsigned int quotient = (row - 1) / 94;
    unsigned int mark;
    if (quotient<max_boards){
        mark = quotient;
    }else{
        mark = max_boards - 1;
    }
    switch(mark) {
        case 0  :
            thermC = 1;
        case 1  :
            thermC = 3;
        case 2  :
            thermC = 7;
        case 3  :
            thermC = 15;
        case 4  :
            thermC = 31;
        case 5  :
            thermC = 63;
        case 6  :
            thermC = 127;
        case 7  :
            thermC = 255;
        case 8  :
            thermC = 511;
        case 9  :
            thermC = 1023;
        case 10 :
            thermC = 2047;
        case 11 :
            thermC = 4095;
        case 12 :
            thermC = 8191;
        default :
            thermC = 1;
            
    return thermC;
    }
}