//-------------------------------------------------------------------------------
// 
//  Treehouse Inc.
//  Colorado Springs, Colorado
// 
//  Copyright (c) 2016 by Treehouse Designs Inc. 
// 
//  This code is the property of Treehouse, Inc. (Treehouse) and may not be redistributed
//  in any form without prior written permission from the copyright holder, Treehouse.
//
//  The above copyright notice and this permission notice shall be included in
//  all copies or substantial portions of the Software.
//   
//-------------------------------------------------------------------------------
// 
//  REVISION HISTORY:
//  
//   $Author: $
//   $Rev: $
//   $Date: $
//   $URL: $
// 
//-------------------------------------------------------------------------------

#include "mbed.h"
#include "clocks.h"
#include "globals.h"
#include "Ticker.h"
#include "stdlib.h"
#include "all_io.h"
#include "menu.h"
unsigned short i;
unsigned short numFast;

volatile bool dosFlip = FALSE;
volatile bool dofFlip = FALSE;
volatile bool enable = FALSE;

void slowFlip() {
    dosFlip = TRUE;
}

void fastFlip() {
    dofFlip = TRUE;
}

void initOut(void){
    /*ec2  = 1;
    ec15 = 1;
    ec26 = 1;
    ec6  = 1;
    ec12 = 1;
    ec25 = 1;
    ec36 = 1;
    ec31 = 1;
    ec9  = 1;
    ec5  = 1;
    ec24 = 1;
    ec11 = 1;
    ec1  = 1;
    ec10 = 1;
    ec23 = 1;
    ec7  = 1;
    ec18 = 1;
    ec14 = 1;
    ec27 = 1;
    ec19 = 1;
    ec32 = 1;
    ec35 = 1;
    ec21 = 1;
    ec30 = 1;
    ec33 = 1;
    ec20 = 1;
    ec34 = 1;
    ec29 = 1;
    ec8  = 1;
    ec4  = 1;
    ec17 = 1;
    ec13 = 1;
    ec26 = 1;
    ec22 = 1;*/
    for(i = 0; i < 36; i++){
        ec[i] = 1;
    }
}

void flipSlow(void){
    dosFlip = FALSE;
    if(enable == FALSE){
        /*ec2 = !ec2;
        ec15 = !ec15;
        ec26 = !ec26;
        ec6 = !ec6;
        ec12 = !ec12;
        ec25 = !ec25;
        ec36 = !ec36;
        ec31 = !ec31;
        ec9 = !ec9;
        ec5 = !ec5;
        ec24 = !ec24;
        ec11 = !ec11;
        ec1 = !ec1;
        ec10 = !ec10;
        ec23 = !ec23;
        ec7 = !ec7;
        ec18 = !ec18;
        ec14 = !ec14;
        ec27 = !ec27;
        ec19 = !ec19;
        ec32 = !ec32;
        ec35 = !ec35;
        ec21 = !ec21;
        ec30 = !ec30;
        ec33 = !ec33;
        ec20 = !ec20;
        ec34 = !ec34;
        ec29 = !ec29;
        ec8 = !ec8;
        ec4 = !ec4;
        ec17 = !ec17;
        ec13 = !ec13;
        ec26 = !ec26;
        ec22 = !ec22;*/
        for (i = numFast; i < 36; i++){
            if (ec[i] == 1){
                ec[i] = 0;
            }else{
                ec[i] = 1;
            }
        }
        
    }
}

void flipFast(void){
    dofFlip = FALSE;
    if(enable == TRUE){
        for (i = 0; i < 36; i++){
            if (ec[i] == 1){
                ec[i] = 0;
            }else{
                ec[i] = 1;
            }
        }
    }else{
        for (i = 0; i < numFast; i++){
            if (ec[i] == 1){
                ec[i] = 0;
            }else{
                ec[i] = 1;
            }
        }
    }
        /*ec2 = !ec2;
        ec15 = !ec15;
        ec26 = !ec26;
        ec6 = !ec6;
        ec12 = !ec12;
        ec25 = !ec25;
        ec36 = !ec36;
        ec31 = !ec31;
        ec9 = !ec9;
        ec5 = !ec5;
        ec24 = !ec24;
        ec11 = !ec11;
        ec1 = !ec1;
        ec10 = !ec10;
        ec23 = !ec23;
        ec7 = !ec7;
        ec18 = !ec18;
        ec14 = !ec14;
        ec27 = !ec27;
        ec19 = !ec19;
        ec32 = !ec32;
        ec35 = !ec35;
        ec21 = !ec21;
        ec30 = !ec30;
        ec33 = !ec33;
        ec20 = !ec20;
        ec34 = !ec34;
        ec29 = !ec29;
        ec8 = !ec8;
        ec4 = !ec4;
        ec17 = !ec17;
        ec13 = !ec13;
        ec26 = !ec26;
        ec22 = !ec22;
    }*/
}

void checkFlip(void){
    if(dosFlip == TRUE){
        flipSlow();
    }
    if(dofFlip == TRUE){
        flipFast();
    }
}

void ILR(void){
    enable = TRUE;
    flipFast();
}
    