//-------------------------------------------------------------------------------
// 
//  Treehouse Designs Inc.
//  Colorado Springs, Colorado
// 
//  Copyright (c) 2016 by Treehouse Designs Inc. 
//  Copyright (c) 2018 by Agility Power Systems Inc. 
// 
//  This code is the property of Treehouse Designs, Inc. (Treehouse) and
//  Agility Power Systems Inc. (Agility) and may not be redistributed
//  in any form without prior written permission from 
//  both copyright holders, Treehouse and Agility.
//
//  The above copyright notice and this permission notice shall be included in
//  all copies or substantial portions of the Software.
// 
//   
//-------------------------------------------------------------------------------
// 
//  REVISION HISTORY:
//  
//   $Author: $
//   $Rev: $
//   $Date: $
//   $URL: $
// 
//-------------------------------------------------------------------------------

#include "mbed.h"
#include "globals.h"
#include "parameters.h"
#include "boards.h"
#include "lut.h"
#include "all_io.h"
#include "serial.h"
#include "stdio.h"
#include "th_rtz.h"

unsigned int boardEnableBits;

/*******************************************************************************
initI2C
*******************************************************************************/
void initI2C(void){
    
}

/*******************************************************************************
initI2C
*******************************************************************************/
void setFan(unsigned int temperatureVal){
    float fan_duty = temperatureVal/TEMPERATURE_THRESH;
    fan_on.period(FAN_PERIOD);
    fan_on.write(fan_duty);
}

/*******************************************************************************
initBoards
*******************************************************************************/
void initBoards(struct adcValues adcVals){
    //en_out = 32;
    //setBoardEnables(16383);
    
    //Need to enable all chips fast. NEW code here
    
}

/*******************************************************************************
getMasterCommands
*******************************************************************************/
unsigned short getMasterCommands(void){
    unsigned short slave_code = 0;
    if(pulseReady){
          slave_code = Slave_RXstr();
    }
    return slave_code;
}

/*******************************************************************************
sendSlaveCommands
*******************************************************************************/
void sendSlaveCommands(unsigned short slave_code){
    
    char data_write;
    int status;
    
    // Write slave1 code
    data_write = slave_code | 0x00FF;
    sendByte(1, data_write);
    
    // Write slave2 code
    data_write = (slave_code | 0xFF00) >> 8;
    sendByte(2, data_write);
    
}

/*******************************************************************************
delay
*******************************************************************************/
void delay(long ticks)
{
   long i;
   for(i=0;i<ticks;i++);    
}  

/*******************************************************************************
setBoardControls
*******************************************************************************/
void setBoardControls(unsigned int tCode)
{
    //for(unsigned int b=0; b<max_boards; b++){
        //wr_out = 0;
        //en_out_code = bCodeRow[b];

        //wr_out_code = 1<<b;
        //wr_out = ~wr_out_code;
        //en_out = en_out_code;
        
        //wait_us(250);
    //}
    //for(unsigned int b=max_boards; b<13; b++){

        //wr_out_code = 1<<b;
        //wr_out = ~wr_out_code;
        //en_out = 0;
        
        //wait_us(250);
    //}
}

/*******************************************************************************
setBoardEnables
*******************************************************************************/
unsigned int setBoardEnables(unsigned int tCode)
{
    //wr_out = tCode;
    //unsigned int en_out_save = en_out;
    //en_out = 0;
    //wr_out = ~tCode;
    //en_out = en_out_save;
    return tCode;
}

/*******************************************************************************
setBoardWeights
*******************************************************************************/
unsigned int setBoardWeights(unsigned int bCode)
{
   //en_out = bCode;
   toggleLatchSignal();
   return bCode;
}

/*******************************************************************************
toggleLatchSignal
*******************************************************************************/
void toggleLatchSignal(void){
    //extchlat = OFF;
    //extchlat = ON;
    //extchlat = OFF;
}    

/************************************************************
* Routine: checkRange
* Input:   setval
*          limlo -- low limit
*          limhi -- high limit
* Returns:  1 if entry validates and is written
*           0 if entry fails
*           -1 if it slips past
* Description:
* Checks if setvalue is between the given limits.
*
**************************************************************/
int checkRange(int setvalue, int limlo, int limhi)
{
   if ((setvalue >= limlo) && (setvalue <= limhi)){
      return 1;
   }else{
      return 0;
   }
}

/*******************************************************************************
startConverter
*******************************************************************************/
void startConverter(unsigned int reg)
{
    if(!running){
        running = TRUE;
        // Fire in the hole!
        //wr_out_code = setBoardEnables(reg);
   
        sprintf(strbuf, "\r\nConverter started");
        sendSerial(strbuf);
    }
}   

/*******************************************************************************
stopConverter - stop the converter and set outputs to 0
*******************************************************************************/
void stopConverter(void)
{
    if(running){
        //en_out = 32;
        //wr_out_code = setBoardEnables(ALLON);
        running = FALSE;
        sprintf(strbuf, "\r\nConverter stopped");
        sendSerial(strbuf);
    }
}

/*******************************************************************************
checkLevels
*******************************************************************************/
struct statusValues checkLevels(struct adcValues adcVals){
    
    struct statusValues statVals;

    // Check 48V levels
    if(adcVals.v48 > V48_HI){
        statVals.V48_IS_HI = TRUE;
        statVals.V48_IS_LO = FALSE;
    }else if(adcVals.v48 < V48_LO){
        statVals.V48_IS_HI = FALSE;
        statVals.V48_IS_LO = TRUE;
    }else{
        statVals.V48_IS_HI = FALSE;
        statVals.V48_IS_LO = FALSE;
    }

    // Check 12V levels
    if(adcVals.v12 > V12_HI){
        statVals.V12_IS_HI = TRUE;
        statVals.V12_IS_LO = FALSE;
    }else if(adcVals.v12 < V12_LO){
        statVals.V12_IS_HI = FALSE;
        statVals.V12_IS_LO = TRUE;
    }else{
        statVals.V12_IS_HI = FALSE;
        statVals.V12_IS_LO = FALSE;
    }
    return statVals;
}


/*******************************************************************************
updateMasterControls
*******************************************************************************/
unsigned short updateMasterControls(unsigned short ref){

    unsigned int tBuf = getLUT_thermCode(ref);
    //if(max_boards <= 3){
    //    getLUT_binCodeArray(ref);
    //    setBoardControls(tBuf);
    //}else{
        //wr_out_code = setBoardEnables(tBuf);
        //unsigned int bBuf = getLUT_binCode(ref);
        //en_out_code = setBoardWeights(bBuf);
    //}
    unsigned short slave_code = 0;
    return slave_code;
}

void XupdateControls(unsigned short ref){

    sprintf(strbuf, "refr=%d\r\n", ref);
    sendSerial(strbuf);
    
    ref = ref/64;
    
    sprintf(strbuf, "refc=%d\r\n", ref);
    sendSerial(strbuf);
    
    sendSerial("enter updateControls\r\n");
    unsigned int cBuf = getLUT_thermCode(ref);
    sendSerial("cBuf1 updateControls\r\n");
    //wr_out_code = setBoardEnables(cBuf);
    sendSerial("wr_out_code updateControls\r\n");
    
    //cBuf = getLUT_binCode(ref);
    sendSerial("cBuf2 updateControls\r\n");
    //en_out_code = setBoardWeights(cBuf);
    sendSerial("en_out_code updateControls\r\n");
    
    wait(0.5);
}

/*******************************************************************************
updateSlaveControls
*******************************************************************************/
void updateSlaveControls(unsigned short ref){

    unsigned int tBuf = getLUT_thermCode(ref);
    //if(max_boards <= 3){
    //    getLUT_binCodeArray(ref);
    //    setBoardControls(tBuf);
    //}else{
        //wr_out_code = setBoardEnables(tBuf);
        //unsigned int bBuf = getLUT_binCode(ref);
        //en_out_code = setBoardWeights(bBuf);
    //}
}