//-------------------------------------------------------------------------------
// 
//  Treehouse Inc.
//  Colorado Springs, Colorado
// 
//  Copyright (c) 2016 by Treehouse Designs Inc. 
// 
//  This code is the property of Treehouse, Inc. (Treehouse) and may not be redistributed
//  in any form without prior written permission from the copyright holder, Treehouse.
//
//  The above copyright notice and this permission notice shall be included in
//  all copies or substantial portions of the Software.
//   
//-------------------------------------------------------------------------------
// 
//  REVISION HISTORY:
//  
//   $Author: $
//   $Rev: $
//   $Date: $
//   $URL: $
// 
//-------------------------------------------------------------------------------

#ifndef menu_H
#define menu_H

#include "mbed.h"

extern bool running;

extern volatile bool updateReady;

extern bool buck;

extern unsigned int binCode[WEIGHT_BIN_WIDTH+1];
extern unsigned int thermCode[BOARDS_THERMCODE_WIDTH+1];

extern const float LUT_VER;

extern unsigned int en_out_code;
extern unsigned int wr_out_code;

extern unsigned int loopTime;
extern Timer masterTimer;

void initDRT(void);
void updateTerminal(struct adcValues, struct statusValues);

enum menuTypes {MENU_DCM1, MENU_CALIBRATE, MENU_TEST, MENU_MAIN};

void clrScrn(void);
void menuRedraw(bool);
void menuPrompt(int);

void menu_banner(void);

extern unsigned short row;
extern short row_test;

#endif