//-------------------------------------------------------------------------------
// 
//  Treehouse Designs Inc.
//  Colorado Springs, Colorado
// 
//  Copyright (c) 2016 by Treehouse Designs Inc. 
//  Copyright (c) 2018 by Agility Power Systems Inc. 
// 
//  This code is the property of Treehouse Designs, Inc. (Treehouse) and
//  Agility Power Systems Inc. (Agility) and may not be redistributed
//  in any form without prior written permission from 
//  both copyright holders, Treehouse and Agility.
//
//  The above copyright notice and this permission notice shall be included in
//  all copies or substantial portions of the Software.
// 
//   
//-------------------------------------------------------------------------------
// 
//  REVISION HISTORY:
//  
//   $Author: $
//   $Rev: $
//   $Date: $
//   $URL: $
// 
//-------------------------------------------------------------------------------

#ifndef GLOBALS_H
#define GLOBALS_H


#ifdef DEBUG_TEST
#define DEBUG 1
#else
#define DEBUG 0
#endif

#define TRUE  1
#define FALSE 0

#define GET FALSE
#define SET TRUE

#define NO_PROMPT FALSE
#define WITH_PROMPT TRUE

#define ON  1
#define OFF 0

#define UPDATE_REFRESH_DELAY_US 500000.0
const unsigned int LOOP_COUNTER = 500000.0/500;

#define BOARD_ENABLE_DELAY_MS 50

#define ALLON 0x3FFF
const int allon[] = {1,1,1,1, 1,1,1,1, 1,1,1,1, 1,1,1,1};
#define ALLOFF 0x0000
const int alloff[] = {0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0};

#define MAX_BOARDS 12
#define MAX_REGISTERS 1

#define WEIGHT_BIN_WIDTH 5
#define BOARDS_THERMCODE_WIDTH 12

#define CURRENT_CONTROL_OFFSET 0.0

extern int menuLevel;

#define LEVEL_MAIN 0

struct adcValues{
    unsigned short v48;
    unsigned short v12;
    unsigned short i12;
};

struct statusValues{
    bool V48_IS_HI;
    bool V48_IS_LO;
    bool V12_IS_HI;
    bool V12_IS_LO;
};

struct displayValues{
    double v48f;
    double v12f;
    double i12f;
};

extern void processCommand(void);

#define I2C_MASTER 0x70
#define I2C_SLAVE1 0x71
#define I2C_SLAVE2 0x72
#define myI2Caddress I2C_MASTER
//#define myI2Caddress I2C_SLAVE1
//#define myI2Caddress I2C_SLAVE2

//const unsigned short i2c_addr_slave1 = I2C_SLAVE1 << 1;
//const unsigned short i2c_addr_slave2 = I2C_SLAVE2 << 1;

#endif
