//-------------------------------------------------------------------------------
// 
//  Treehouse Designs Inc.
//  Colorado Springs, Colorado
// 
//  Copyright (c) 2016 by Treehouse Designs Inc. 
//  Copyright (c) 2018 by Agility Power Systems Inc. 
// 
//  This code is the property of Treehouse Designs, Inc. (Treehouse) and
//  Agility Power Systems Inc. (Agility) and may not be redistributed
//  in any form without prior written permission from 
//  both copyright holders, Treehouse and Agility.
//
//  The above copyright notice and this permission notice shall be included in
//  all copies or substantial portions of the Software.
// 
//   
//-------------------------------------------------------------------------------
// 
//  REVISION HISTORY:
//  
//   $Author: $
//   $Rev: $
//   $Date: $
//   $URL: $
// 
//-------------------------------------------------------------------------------

#ifndef BOARDS_H
#define BOARDS_H

#include "adc_defs.h"

extern volatile bool pulseReady;

const float TEMPERATURE_THRESH = 1000.0;
const float FAN_PERIOD = 0.02f;

#define VOLTAGE_TOLERANCE 0.1
const unsigned int V48_HI = (unsigned int)ADC_SCALE_FACTOR*(VOLTAGE_48_ACTUAL_VALUE/VOLTAGE_TARG_VALUE)*(1.0+VOLTAGE_TOLERANCE);
const unsigned int V48_LO = (unsigned int)ADC_SCALE_FACTOR*(VOLTAGE_48_ACTUAL_VALUE/VOLTAGE_TARG_VALUE)*(1.0-VOLTAGE_TOLERANCE);
const unsigned int V12_HI = (unsigned int)ADC_SCALE_FACTOR*(VOLTAGE_12_ACTUAL_VALUE/VOLTAGE_TARG_VALUE)*(1.0+VOLTAGE_TOLERANCE);
const unsigned int V12_LO = (unsigned int)ADC_SCALE_FACTOR*(VOLTAGE_12_ACTUAL_VALUE/VOLTAGE_TARG_VALUE)*(1.0-VOLTAGE_TOLERANCE);

void setFan(unsigned int temperatureVal);

void initBoards(struct adcValues);

extern bool buck;

extern unsigned int boardEnableBits;
extern unsigned int boardsActive;

extern unsigned int en_out_code;
extern unsigned int wr_out_code;


extern unsigned int bCodeRow[];

void setBoardControls(unsigned int);
unsigned int setBoardEnables(unsigned int);
unsigned int setBoardWeights(unsigned int);

int checkRange(int, int, int);

void toggleLatchSignal(void);

void startConverter(unsigned int);
void stopConverter(void);

struct statusValues checkLevels(struct adcValues);
unsigned short updateMasterControls(unsigned short);
void updateSlaveControls(unsigned short);
void XupdateControls(unsigned short);

//extern DigitalOut Mstr_Tx1(PB_6);
//DigitalOut Mstr_Tx2(PB_7);
//InterruptIn Slave_Rx(PB_6);
//extern InterruptIn Slave_Rx(PB_7);

extern const unsigned short i2c_addr_slave1;
extern const unsigned short i2c_addr_slave2;

void initI2C(void);
unsigned short getMasterCommands(void);
void sendSlaveCommands(unsigned short);

#endif