//-------------------------------------------------------------------------------
// 
//  Treehouse Designs Inc.
//  Colorado Springs, Colorado
// 
//  Copyright (c) 2016 by Treehouse Designs Inc. 
//  Copyright (c) 2018 by Agility Power Systems Inc. 
// 
//  This code is the property of Treehouse Designs, Inc. (Treehouse) and
//  Agility Power Systems Inc. (Agility) and may not be redistributed
//  in any form without prior written permission from 
//  both copyright holders, Treehouse and Agility.
//
//  The above copyright notice and this permission notice shall be included in
//  all copies or substantial portions of the Software.
// 
//   
//-------------------------------------------------------------------------------
// 
//  REVISION HISTORY:
//  
//   $Author: $
//   $Rev: $
//   $Date: $
//   $URL: $
// 
//-------------------------------------------------------------------------------

#ifndef ADC_DEFS_H
#define ADC_DEFS_H

#include "parameters.h"

const unsigned int ADC_SCALE_FACTOR = ADC_MAX_VALUE/2;

#define VOLTAGE_TARG_VALUE 1.65
#define VOLTAGE_48_ACTUAL_VALUE 1.51
#define VOLTAGE_12_ACTUAL_VALUE 1.53
const double VOLTAGE_48_CORRECTION = VOLTAGE_TARG_VALUE/VOLTAGE_48_ACTUAL_VALUE/ADC_SCALE_FACTOR;
const double VOLTAGE_12_CORRECTION = VOLTAGE_TARG_VALUE/VOLTAGE_12_ACTUAL_VALUE/ADC_SCALE_FACTOR;
const double VOLTAGE_48_FACTOR = 48.0*VOLTAGE_48_CORRECTION;
const double VOLTAGE_12_FACTOR = 12.0*VOLTAGE_12_CORRECTION;

#define CURRENT_12_DIV_FACTOR5 -188
#define CURRENT_12_DIV_FACTOR4 -186
#define CURRENT_12_DIV_FACTOR3 -182
#define CURRENT_12_DIV_FACTOR2 -177
#define CURRENT_12_DIV_FACTOR1 -179
#define CURRENT_12_DIV_FACTOR0 -175

#define CURRENT_12_DIV_THRESH5 1600
#define CURRENT_12_DIV_THRESH4 800
#define CURRENT_12_DIV_THRESH3 600
#define CURRENT_12_DIV_THRESH2 400
#define CURRENT_12_DIV_THRESH1 200


//const double ROW_CORRECTION_FACTOR = 1.017; // 2.6W/chip avg.
const double ROW_CORRECTION_FACTOR = 0.85; // 3W/chip avg.
#define ROW_HYSTERESIS 1

extern double CURRENT_12_OFFSET;

#endif