//-------------------------------------------------------------------------------
// 
//  Treehouse Designs Inc.
//  Colorado Springs, Colorado
// 
//  Copyright (c) 2016 by Treehouse Designs Inc. 
//  Copyright (c) 2018 by Agility Power Systems Inc. 
// 
//  This code is the property of Treehouse Designs, Inc. (Treehouse) and
//  Agility Power Systems Inc. (Agility) and may not be redistributed
//  in any form without prior written permission from 
//  both copyright holders, Treehouse and Agility.
//
//  The above copyright notice and this permission notice shall be included in
//  all copies or substantial portions of the Software.
// 
//   
//-------------------------------------------------------------------------------
// 
//  REVISION HISTORY:
//  
//   $Author: $
//   $Rev: $
//   $Date: $
//   $URL: $
// 
//-------------------------------------------------------------------------------

#include "mbed.h"
#include "math.h"
#include "globals.h"
#include "parameters.h"
#include "all_io.h"
#include "stdio.h"
#include "stdlib.h"
#include "serial.h"
#include "adc.h"
#include "adc_defs.h"
#include "menu.h"
#include "boards.h"
#include "command.h"

unsigned int en_out_code;
unsigned int wr_out_code;
unsigned int max_boards = 13;
unsigned int max_rows = 2048;
//unsigned int bCodeArray[2048][13];
unsigned int bCodeRow[13];

unsigned short my12=0;
volatile bool updateReady = FALSE;
unsigned int loopTime = 0;
bool raw = FALSE;
bool running = FALSE;
bool testing = FALSE;
bool buck = TRUE;

double CURRENT_48_OFFSET = 33940;
double CURRENT_24_OFFSET = 33580;
double CURRENT_12_OFFSET = 33256;

unsigned short row = 0;
int row_test = 0;
int row_print = 0;

Timer masterTimer;

int main()
{
   myled = 0;
   extchlat = OFF;
   wr_out_code = setBoardEnables(ALLON);
   en_out_code = setBoardWeights(32);
   running = FALSE;
   
   initSerial();
    
   initDRT(); // Display Refresh Timer
   
   initADC();

   struct adcValues adcVals = getADCresults();
   struct displayValues dispVals = calcDisplayValues(adcVals);
   struct statusValues statVals = checkLevels(adcVals);
   
   row = (unsigned short)(dispVals.i12f*dispVals.v12f*ROW_CORRECTION_FACTOR);
   unsigned int old_row = row;
   
   menu_banner();
   //initBoards(adcVals);
   sprintf(strbuf, "\r\nPress Enter to continue");
   sendSerial(strbuf);
   while(waitCommand()){ // Wait for user to press Enter
   }
   
   menuRedraw(WITH_PROMPT);
   
   initBoards(adcVals);

   while (1)
   {
      adcVals = getADCresults();
      
      dispVals = calcDisplayValues(adcVals);
      
      statVals = checkLevels(adcVals);
      
      processCommand();

      // Select RUN from menu to activate running mode.
      // BRDS, MULT activate testing mode. MY12 emulates running mode wthout being in running mode.
      // CAL and UNCAL do not change state of running or testing.
      if(adcVals.i12 < CURRENT_12_OFFSET){    
            row = (unsigned short)(dispVals.i12f*dispVals.v12f*ROW_CORRECTION_FACTOR);
            //updateControls(CURRENT_12_OFFSET-adcVals.i12);
            buck = TRUE;
      }else{
            //row = (unsigned short)(dispVals.i12f*dispVals.v12f*(-ROW_CORRECTION_FACTOR));
            row = (unsigned short)(dispVals.i12f*dispVals.v12f*(-ROW_CORRECTION_FACTOR));
            //updateControls(adcVals.i12-CURRENT_12_OFFSET);
            buck = FALSE;
      }
      row_test = abs((int)(row-old_row));
      if(running){
          //The current sensors results are single-ended. Results below the midpoint are for buck mode, above is for boost mode.
          if(row_test>ROW_HYSTERESIS){
             old_row = row;
             //updateControls(CURRENT_12_OFFSET-adcVals.i12);
             if(row<=1023){
                 updateControls(row);
             }
             row_print = row;
             myled = !myled;
          }//else if(row_test<=ROW_HYSTERESIS){
           //  old_row = row;
           //  updateControls(row);
          //}
          //count++;
      }else if(!testing){
          row_test = abs((int)(my12-old_row));
          if(row_test>ROW_HYSTERESIS){
             old_row = my12;
             //updateControls(CURRENT_12_OFFSET-adcVals.i12);
             if(row<=1023){
                 //updateControls(row);
                 updateControls(my12);
             }
             row_print = my12;
             myled = !myled;
          }
      }
      
      if(updateReady){
         updateReady = FALSE;
         updateTerminal(adcVals, statVals);  // May want to gate this call when we run a headless system.
         //loopTime = masterTimer.read_ms();// - loopTime;
         //myled = !myled;

      }
   }//end while(1)
}//end void main(void)

