//-------------------------------------------------------------------------------
// 
//  Treehouse Designs Inc.
//  Colorado Springs, Colorado
// 
//  Copyright (c) 2016 by Treehouse Designs Inc. 
//  Copyright (c) 2018 by Agility Power Systems Inc. 
// 
//  This code is the property of Treehouse Designs, Inc. (Treehouse) and
//  Agility Power Systems Inc. (Agility) and may not be redistributed
//  in any form without prior written permission from 
//  both copyright holders, Treehouse and Agility.
//
//  The above copyright notice and this permission notice shall be included in
//  all copies or substantial portions of the Software.
// 
//   
//-------------------------------------------------------------------------------
// 
//  REVISION HISTORY:
//  
//   $Author: $
//   $Rev: $
//   $Date: $
//   $URL: $
// 
//-------------------------------------------------------------------------------

#include "mbed.h"
#include "stdint.h"
#include "globals.h"
#include "lut.h"

unsigned int binCode[WEIGHT_BIN_WIDTH+1];
unsigned int thermCode[BOARDS_THERMCODE_WIDTH+1];

#include "lut_data_en_v1p5_1.h"
#include "lut_data_slot_v1p5_1.h"

//#include "lut_data_en_v1p5_2.h"
//#include "lut_data_slot_v1p5_2.h"

//#include "lut_data_en_v1p5_3.h"
//#include "lut_data_slot_v1p5_3.h"

//#include "lut_data_en_v1p5_12.h"
//#include "lut_data_slot_v1p5_12.h"

//#include "lut_data_en_v1p5_13.h"
//#include "lut_data_slot_v1p5_13.h"

/*******************************************************************************
getLUT_binCodeArray - gets output codes from LUT using row reference.
*******************************************************************************/
void getLUT_binCodeArray(unsigned short row){
    switch(max_boards) {
        case 1  :
            if(row<MAX_LUT_ENTRIES_1){
                for(unsigned int b=0;b<max_boards;b++){
                    bCodeRow[b] = binC_1[row];
                }
            }else{
                for(unsigned int b=0;b<max_boards;b++){
                    bCodeRow[b] = binC_1[MAX_LUT_ENTRIES_1-1];
                }
            }
            break;
        /*case 2  :
            if(row<MAX_LUT_ENTRIES_2){
                for(unsigned int b=0;b<max_boards;b++){
                    bCodeRow[b] = binC_2[row][b];
                }
            }else{
                for(unsigned int b=0;b<max_boards;b++){
                    bCodeRow[b] = binC_2[MAX_LUT_ENTRIES_2-1][b];
                }
            }
            break;
        case 3  :
            if(row<MAX_LUT_ENTRIES_3){
                for(unsigned int b=0;b<max_boards;b++){
                    bCodeRow[b] = binC_3[row][b];
                }
            }else{
                for(unsigned int b=0;b<max_boards;b++){
                    bCodeRow[b] = binC_3[MAX_LUT_ENTRIES_3-1][b];
                }
            }
            break;
        default :
            if(row<MAX_LUT_ENTRIES_3){
                for(unsigned int b=0;b<max_boards;b++){
                    bCodeRow[b] = binC_3[row][b];
                }
            }else{
                for(unsigned int b=0;b<max_boards;b++){
                    bCodeRow[b] = binC_3[MAX_LUT_ENTRIES_3-1][b];
                }
            }*/
    }
}

/*******************************************************************************
getLUT_binCode - gets output codes from LUT using row reference.
*******************************************************************************/
unsigned int getLUT_binCode(unsigned short row){
    unsigned int binC;
    /*switch(max_boards) {
        case 12  :
            if(row<MAX_LUT_ENTRIES_12){
                binC = binC_12[row];
            }else{
                binC = binC_12[MAX_LUT_ENTRIES_12-1];
            }
            break;
        case 13  :
            if(row<MAX_LUT_ENTRIES_13){
                binC = binC_13[row];
            }else{
                binC = binC_13[MAX_LUT_ENTRIES_13-1];
            }
            break;
        default :
            if(row<MAX_LUT_ENTRIES_13){
                binC = binC_13[row];
            }else{
                binC = binC_13[MAX_LUT_ENTRIES_13-1];
            }
    }*/
    return binC;
}

/*******************************************************************************
getLUT_binCode - gets output codes from LUT using row reference.
*******************************************************************************/
unsigned int getLUT_thermCode(unsigned short row){
    unsigned int thermC;
    switch(max_boards) {
        case 1  :
            if(row<MAX_LUT_ENTRIES_1){
                thermC = thermC_1[row];
            }else{
                thermC = thermC_1[MAX_LUT_ENTRIES_1-1];
            }
            break;
        /*case 2  :
            if(row<MAX_LUT_ENTRIES_2){
                thermC = thermC_2[row];
            }else{
                thermC = thermC_2[MAX_LUT_ENTRIES_2-1];
            }
            break;
        case 3  :
            if(row<MAX_LUT_ENTRIES_3){
                thermC = thermC_3[row];
            }else{
                thermC = thermC_3[MAX_LUT_ENTRIES_3-1];
            }
            break;
        case 12  :
            if(row<MAX_LUT_ENTRIES_12){
                thermC = thermC_12[row];
            }else{
                thermC = thermC_12[MAX_LUT_ENTRIES_12-1];
            }
            break;
        case 13  :
            if(row<MAX_LUT_ENTRIES_13){
                thermC = thermC_13[row];
            }else{
                thermC = thermC_13[MAX_LUT_ENTRIES_13-1];
            }
            break;
        default :
            if(row<MAX_LUT_ENTRIES_13){
                thermC = thermC_13[row];
            }else{
                thermC = thermC_13[MAX_LUT_ENTRIES_13-1];
            }*/
    }
    return thermC;
}