//-------------------------------------------------------------------------------
// 
//  Treehouse Inc.
//  Colorado Springs, Colorado
// 
//  Copyright (c) 2016 by Treehouse Designs Inc. 
// 
//  This code is the property of Treehouse, Inc. (Treehouse) and may not be redistributed
//  in any form without prior written permission from the copyright holder, Treehouse.
//
//  The above copyright notice and this permission notice shall be included in
//  all copies or substantial portions of the Software.
//   
//-------------------------------------------------------------------------------
// 
//  REVISION HISTORY:
//  
//   $Author: $
//   $Rev: $
//   $Date: $
//   $URL: $
// 
//-------------------------------------------------------------------------------

#include "mbed.h"
#include "clocks.h"
#include "globals.h"
#include "Ticker.h"
#include "stdlib.h"
#include "all_io.h"
//#include "menu.h"
unsigned short i;
unsigned int numOn;

int enkey[6] = {2, 1, 1, 1, 1, 1};

volatile bool dosFlip = FALSE;
volatile bool dofFlip = FALSE;
volatile bool enable = FALSE;
volatile bool stepForward = FALSE;

void slowFlip() {
    dosFlip = TRUE;
}

void fastFlip() {
    dofFlip = TRUE;
}

void initOut(void){
    /*
    en1 = 1;
    en2 = 1;
    en4 = 1;
    en8 = 1;
    en16 = 1;
    en32 = 1;*/
    for(i = 0; i < 5; i++){
        en[i] = 1;
    }
    en[5] = 0;
}
/*
void flipSlow(void){
    dosFlip = FALSE;
    if(enable != TRUE){
        //for (i = numFast; i < 36; i++){
        //    if (ec[i] == 1){
        //        ec[i] = 0;
        //    }else{
        //        ec[i] = 1;
        //    }
        //}
        for (i = 0; i < 6; i++){
            if (enkey[i] != 1){
                if (en[i] == 1){
                    en[i] = 0;
                }else{
                    en[i] = 1;
                }
            }
        }
    }
}

void flipFast(void){
    dofFlip = FALSE;
    if(enable == TRUE){
        for (i = 0; i < 6; i++){
            if (en[i] == 1){
                en[i] = 0;
            }else{
                en[i] = 1;
            }
        }
    }else{
        for (i = 0; i < 6; i++){
            if (enkey[i] == 1){
                if (en[i] == 1){
                    en[i] = 0;
                }else{
                    en[i] = 1;
                }
            }
        }
    }
}

void checkFlip(void){
    if(dosFlip == TRUE){
        flipSlow();
    }
    if(dofFlip == TRUE){
        flipFast();
    }
    if(enable == TRUE) {
        for (i=0; i < 6; i++) {
            en[i] = 1;
        }
    }
}

void progress(void){
    for (i = 0; i < 5; i++){
        if (stepForward == TRUE){
            en[i] = 1;
            enkey[i] = 2;
            stepForward = FALSE;
        } else if (enkey[i] == 2) {
            en[i] = 0;
            enkey[i] = 1;
            stepForward = TRUE;
        }
    }
}

void ILR(void){
    enable = TRUE;
    flipFast();
}*/

void ILR(void){
    enable = TRUE;
}

void setClocks(int num){
    numOn = num;
    if (num == 32 or enable == TRUE){
        en[5] = 1;
    } else {
        en[5] = 0;
        if (num >= 16) {
            en[4] = 1;
            num = num - 16;
        } else {
            en[4] = 0;
        }
        if (num >= 8) {
            en[3] = 1;
            num = num - 8;
        } else {
            en[3] = 0;
        }
        if (num >= 4) {
            en[2] = 1;
            num = num - 4;
        } else {
            en[2] = 0;
        }
        if (num >= 2) {
            en[1] = 1;
            num = num - 2;
        } else {
            en[1] = 0;
        }
        if (num == 1) {
            en[0] = 1;
        } else {
            en[0] = 0;
        }
    }
    WR = 1;
    wait_us(250);
    WR = 0;
}
