//-------------------------------------------------------------------------------
// 
//  Treehouse Designs Inc.
//  Colorado Springs, Colorado
// 
//  Copyright (c) 2016 by Treehouse Designs Inc. 
//  Copyright (c) 2018 by Agility Power Systems Inc. 
// 
//  This code is the property of Treehouse Designs, Inc. (Treehouse) and
//  Agility Power Systems Inc. (Agility) and may not be redistributed
//  in any form without prior written permission from 
//  both copyright holders, Treehouse and Agility.
//
//  The above copyright notice and this permission notice shall be included in
//  all copies or substantial portions of the Software.
// 
//   
//-------------------------------------------------------------------------------
// 
//  REVISION HISTORY:
//  
//   $Author: $
//   $Rev: $
//   $Date: $
//   $URL: $
// 
//-------------------------------------------------------------------------------

#ifndef ADC_DEFS_H
#define ADC_DEFS_H

#include "parameters.h"

const unsigned int ADC_SCALE_FACTOR = ADC_MAX_VALUE/2;

#define VOLTAGE_TARG_VALUE 1.65
#define VOLTAGE_48_ACTUAL_VALUE 1.65
#define VOLTAGE_24_ACTUAL_VALUE 1.55
#define VOLTAGE_12_ACTUAL_VALUE 1.6668
const double VOLTAGE_48_CORRECTION = VOLTAGE_TARG_VALUE/VOLTAGE_48_ACTUAL_VALUE/ADC_SCALE_FACTOR;
const double VOLTAGE_24_CORRECTION = VOLTAGE_TARG_VALUE/VOLTAGE_24_ACTUAL_VALUE/ADC_SCALE_FACTOR;
const double VOLTAGE_12_CORRECTION = VOLTAGE_TARG_VALUE/VOLTAGE_12_ACTUAL_VALUE/ADC_SCALE_FACTOR;
const double VOLTAGE_48_FACTOR = 48.0*VOLTAGE_48_CORRECTION;
const double VOLTAGE_24_FACTOR = 24.0*VOLTAGE_24_CORRECTION;
const double VOLTAGE_12_FACTOR = 12.0*VOLTAGE_12_CORRECTION;

//#define CURRENT_ACTUAL_VALUE 1.7091
//#define CURRENT_TARG_VALUE 1.65
//const double CURRENT_OFFSET = (CURRENT_ACTUAL_VALUE/CURRENT_TARG_VALUE)*ADC_SCALE_FACTOR;
//const double CURRENT_48_OFFSET = 33940;
//const double CURRENT_24_OFFSET = 33580;
//const double CURRENT_12_OFFSET = 33380;
//#define CURRENT_OFFSET 33940
//#define CURRENT_DIV_FACTOR -390
/*
#define CURRENT_48_DIV_FACTOR -368
#define CURRENT_24_DIV_FACTOR -308
#define CURRENT_12_DIV_FACTOR -324
*/
//#define CURRENT_48_DIV_FACTOR -372
#define CURRENT_48_DIV_FACTOR5 -370
#define CURRENT_48_DIV_FACTOR4 -570
#define CURRENT_48_DIV_FACTOR3 -740
#define CURRENT_48_DIV_FACTOR2 -948
#define CURRENT_48_DIV_FACTOR1 -1541
#define CURRENT_48_DIV_FACTOR0 -1610

#define CURRENT_48_DIV_THRESH5 3000
#define CURRENT_48_DIV_THRESH4 2500
#define CURRENT_48_DIV_THRESH3 2000
#define CURRENT_48_DIV_THRESH2 1500
#define CURRENT_48_DIV_THRESH1 500

#define CURRENT_24_DIV_FACTOR -376
//#define CURRENT_12_DIV_FACTOR -356
//#define CURRENT_12_DIV_FACTOR -208

//#define CURRENT_12_DIV_FACTOR5 -305
//#define CURRENT_12_DIV_FACTOR4 -335
//#define CURRENT_12_DIV_FACTOR3 -355
//#define CURRENT_12_DIV_FACTOR2 -391
//#define CURRENT_12_DIV_FACTOR1 -440
//#define CURRENT_12_DIV_FACTOR0 -535

#define CURRENT_12_DIV_FACTOR5 121.81
#define CURRENT_12_DIV_FACTOR4 120.53
#define CURRENT_12_DIV_FACTOR3 117.94
#define CURRENT_12_DIV_FACTOR2 114.7
#define CURRENT_12_DIV_FACTOR1 116
#define CURRENT_12_DIV_FACTOR0 113.4

#define CURRENT_12_DIV_THRESH5 1600
#define CURRENT_12_DIV_THRESH4 800
#define CURRENT_12_DIV_THRESH3 600
#define CURRENT_12_DIV_THRESH2 400
#define CURRENT_12_DIV_THRESH1 200


//const double ROW_CORRECTION_FACTOR = 1.017; // 2.6W/chip avg.
const double ROW_CORRECTION_FACTOR = 0.85; // 3W/chip avg.
#define ROW_HYSTERESIS 1

extern double CURRENT_48_OFFSET;
extern double CURRENT_24_OFFSET;
extern double CURRENT_12_OFFSET;

#endif