#include "mbed.h"
#include "math.h"
#include "globals.h"
#include "parameters.h"
#include "temp.h"
#include "all_io.h"
#include "adc_defs.h"

unsigned int startTemp = 13;
unsigned int maxTemp = 16;
unsigned int tempRange;
float tempercent;
ADC_HandleTypeDef hadc1;
/*Old Setup
int32_t ComputeTemperature(uint32_t measure){
 
      int32_t temperature;
 
      temperature = ((measure * VDD_APPLI / VDD_CALIB) - (int32_t)*TEMP30_CAL_ADDR );
 
      temperature = temperature *(int32_t)(130-30);
 
      temperature = temperature /(int32_t)(*TEMP130_CAL_ADDR -*TEMP30_CAL_ADDR);
 
      temperature = temperature + 30;
 
      return(temperature);
 
}
void ConfigTemperature(void){

 
      //ADC Ready
 
      ADC1->ISR |= ADC_ISR_ADRDY;
 
      //Activation of the clock
 
      RCC->APB2ENR |= RCC_APB2ENR_ADC1EN;
 
      //Continuous mode
 
      ADC1->CFGR1 |= ADC_CFGR1_CONT;
 
      //Channel temp sensor
 
      ADC1->CHSELR |= ADC_CHANNEL_TEMPSENSOR;
 
      //Select the sample time
 
      ADC1->SMPR |= ADC_SMPR_SMP_1;
 
      //Turn on the temp sensor
 
      ADC->CCR |= ADC_CCR_TSEN;
 
      wait(1);
 
      //Start the conversion
 
      ADC1->CR |= ADC_CR_ADSTART;
 
      wait(1);
 
      printf("%Measure %i\n\r", measure);
 
      printf("%The temperature value is %i\n\r",ComputeTemperature(measure));
 
}*/
/*
float GetTemperature(void){
    
    
    hadc1.Instance = ADC1;
    float temperature;
    float sensorValue;
    uint32_t adcCalValue30 = (*TEMP30_CAL_ADDR);
    uint32_t adcCalValue130 = (*TEMP130_CAL_ADDR);

    __HAL_ADC_ENABLE(&hadc);

    // Disable Vbat signal from input channel and wake up temp sensor from power down mode
    ADC->CCR |= ADC_CCR_TSVREFE;
    ADC->CCR &= ~ADC_CCR_VBATE ;


    HAL_ADC_Start(&hadc1);
    //ADC Ready
 
    ADC1->ISR |= ADC_ISR_ADRDY;
 
    //Activation of the clock
 
    RCC->APB2ENR |= RCC_APB2ENR_ADC1EN;
 
    //Continuous mode
 
    ADC1->CFGR1 |= ADC_CFGR1_CONT;
 
    //Channel temp sensor
 
    ADC1->CHSELR |= ADC_CHANNEL_TEMPSENSOR;
 
    //Select the sample time
 
    ADC1->SMPR |= ADC_SMPR_SMP_1;
 
    //Turn on the temp sensor
 
    ADC->CCR |= ADC_CCR_TSEN;
 
    wait(1);
 
    //Start the conversion
 
    ADC1->CR |= ADC_CR_ADSTART;
 
    wait(1);
    //if(HAL_ADC_PollForConversion(&hadc1, 100) == HAL_OK)
    if (2 == 1)
    {
        sensorValue = (float)HAL_ADC_GetValue(&hadc1);
        HAL_ADC_Stop(&hadc1);
        temperature = (int32_t)((130 - 30) / (adcCalValue130 - adcCalValue30) * (sensorValue - adcCalValue30) + 30);
    }
    else if (3 == 1)
    {
        uint32_t returnedValue = HAL_ADC_GetValue(&hadc1);
        sensorValue = (float)(returnedValue/4095*3.3);
        HAL_ADC_Stop(&hadc1);
        temperature = (returnedValue/ADC_SCALE_FACTOR); ///(adcCalValue130 - adcCalValue30)
    }
    else
    {
        temperature = -273;
    }

    return temperature;
}
*/
float GetTemperature(void) {
    return adc_temp.read()*100;
}
void runFan(float temperature)
{
    if (temperature > maxTemp)
    {
        fan_on = 1;
        fan_pwm.write(1.0f);
    }
    else if (temperature < startTemp)
    {
        fan_on = 0 ;
        fan_pwm.write(0.0f);
    }
    else
    {
        fan_on = 1;
        temperature = temperature - startTemp;
        tempRange = maxTemp - startTemp;
        tempercent = temperature/tempRange;
        fan_pwm.write(tempercent);
    }
}