//-------------------------------------------------------------------------------
// 
//  Treehouse Inc.
//  Colorado Springs, Colorado
// 
//  Copyright (c) 2016 by Treehouse Designs Inc. 
// 
//  This code is the property of Treehouse, Inc. (Treehouse) and may not be redistributed
//  in any form without prior written permission from the copyright holder, Treehouse.
//
//  The above copyright notice and this permission notice shall be included in
//  all copies or substantial portions of the Software.
//   
//-------------------------------------------------------------------------------
// 
//  REVISION HISTORY:
//  
//   $Author: $
//   $Rev: $
//   $Date: $
//   $URL: $
// 
//-------------------------------------------------------------------------------

#include "mbed.h"
#include "globals.h"
#include "serial.h"
#include "menu.h"
#include "adc.h"
#include "boards.h"
#include "Ticker.h"
#include "stdlib.h"
#include "lut.h"
#include "temp.h"
#include "clocks.h"

Ticker drt;
unsigned int oldTime=0;

/*******************************************************************************
 drtInt - Display Refresh Timer interrupt handler
*******************************************************************************/
// real time clock interrupt to flash the LED
void drtInt(void)
{
   updateReady = TRUE;
}

/*******************************************************************************
 initDRT - Create Display Refresh Timer interrupt
*******************************************************************************/
// initialize display refresh timer (DRT)
void initDRT(void)
{
   drt.attach_us(&drtInt, UPDATE_REFRESH_DELAY_US); 
}

/*******************************************************************************
 refreshStatus - Refresh status info to the terminal
*******************************************************************************/
void refreshStatus(struct statusValues statVals){
    
    char strbuf_mode[15] = {0};
    char strbuf_running[16] = {0};
    char strbuf_v48[15] = {0};
    char strbuf_v24[15] = {0};
    char strbuf_v12[15] = {0};
    char strbuf_blank[50] = {0};
    
    if(buck){
        sprintf(strbuf_mode, "Buck Mode  | ");
    }else{
        sprintf(strbuf_mode, "Boost Mode | ");
    }
    //sendSerial(strbuf);
    
    if(running){
        sprintf(strbuf_running, "Running     | ");
    }else{
        sprintf(strbuf_running, "NOT Running | ");
    }
    //sendSerial(strbuf);
    
    if(statVals.V48_IS_HI){
        sprintf(strbuf_v48, "V48 HIGH | ");
    }else if(statVals.V48_IS_LO){
        sprintf(strbuf_v48, "V48 LOW  | ");
    }else{
    //    sprintf(strbuf, "V48 OK   | ");
        sprintf(strbuf_v48, "");
        sprintf(strbuf_blank, "           ");
    }
    //sendSerial(strbuf);
    /*
    if(statVals.V24_IS_HI){
        sprintf(strbuf_v24, "V24 HIGH | ");
    }else if(statVals.V24_IS_LO){
        sprintf(strbuf_v24, "V24 LOW  | ");
    }else{
    //    sprintf(strbuf, "V24 OK   | ");
        sprintf(strbuf_v24, "");
        sprintf(strbuf_blank, strcat(strbuf_blank, "           "));
    }
    //sendSerial(strbuf);
    
    if(statVals.V12_IS_HI){
        sprintf(strbuf_v12, "V12 HIGH ");
    }else if(statVals.V24_IS_LO){
        sprintf(strbuf_v12, "V12 LOW  ");
    }else{
    //    sprintf(strbuf, "V12 OK   | ");
        sprintf(strbuf_v12, "");
        sprintf(strbuf_blank, strcat(strbuf_blank, "           "));
    }*/
    //sendSerial(strbuf);
    
    //move cursor to STATUS_ROW and write status info
    //char row = STATUS_ROW + '0';
    sprintf( strbuf, "%c[9;0f", 27); // ESC=27, Move cursor position = [line;columnf
    sendSerial(strbuf);
    
    sprintf(strbuf, "Status: %s%s%s%s%s%s\r\n\r\n", strbuf_mode, strbuf_running, strbuf_v48, strbuf_v24, strbuf_v12, strbuf_blank);
    //sprintf(strbuf, "Status: %s%s%s%s%s%d  \r\n\r\n", strbuf_mode, strbuf_running, strbuf_v48, strbuf_v24, strbuf_v12, row_print);
    sendSerial(strbuf);
    
}

/*******************************************************************************
 refreshData - Refresh voltage and current readings to the terminal
*******************************************************************************/
void refreshData(struct adcValues adcVals){
    //loopTime = masterTimer.read_ms() - oldTime;
    //oldTime = masterTimer.read_ms();
    
    struct displayValues dvals = calcDisplayValues(adcVals);
    
    //double pwr_out=dvals.v12f*dvals.i12f;
    //double pwr_in=dvals.v48f*(dvals.i48f);
    //double pwr_eff=100*pwr_out/pwr_in;
    
    //move cursor to DATA_ROW and write data
    //row = DATA_ROW + '0';
    sprintf( strbuf, "%c[10;0f", 27); // ESC=27, Move cursor position = [line;columnf
    sendSerial(strbuf);
    float temp_reading = GetTemperature();
    
    sprintf(strbuf, "V48=%2.1f | V12=%2.1f, I12=%3.2f | Temp=%f | Test=%2.1f    \r\n", dvals.v48f, dvals.v12f, dvals.i12f, temp_reading, dvals.test_v);
    //sprintf(strbuf, "V48=%2.1f, I48=%2.2f | V24=%2.1f, I24=%2.2f | V12=%2.1f, I12=%2.2f || loop=%d    \r\n", v48f, i48f, v24f, i24f, v12f, i12f, loopTime);
    sendSerial(strbuf);
    sprintf(strbuf, "NumOn=%d \r\n", numOn);
    sendSerial(strbuf); 
    //sprintf(strbuf, "adcVals.i12 = %d     \r\n", adcVals.i12);
    //sendSerial(strbuf);
    //sprintf(strbuf, "Power Out = %4.1f W, Power In = %4.1f W     \r\n", pwr_out, pwr_in);
    //sendSerial(strbuf);
    sprintf( strbuf, "%c[34m", 27 ); // ESC=27, Blue Text
    sendSerial(strbuf);
    //sprintf(strbuf, "Power Efficiency = %2.2f percent    \r\n\r\n", pwr_eff);
    //sendSerial(strbuf);
    sprintf( strbuf, "%c[30m", 27 ); // ESC=27, White Text
    sendSerial(strbuf);
    sprintf(strbuf, "BRDS_code=%d, MULT_code=%d    \r\n", wr_out_code, en_out_code);
    sendSerial(strbuf);
}

/*******************************************************************************
 updateTerminal - Save cursor, write data, restore cursor.
*******************************************************************************/
void updateTerminal(struct adcValues adcVals, struct statusValues statVals){
    //get cursor pos, store in CUR_POS
    sprintf( strbuf, "%c7", 27 ); // ESC=27, Save cursor position = [s
    sendSerial(strbuf);
    
    refreshStatus(statVals);
    refreshData(adcVals);
    
    //move cursor to CUR_POS
    sprintf( strbuf, "%c8", 27 ); // ESC=27, Save cursor position = [s
    sendSerial(strbuf);
}

/*******************************************************************************
 clrScrn - clears terminal and moves cursor to upper-left corner
*******************************************************************************/
// clears terminal
void clrScrn(void){
    sprintf( strbuf, "%c[2J", 27 ); // ESC=27, Clear screen = [2J
    sendSerial(strbuf);
    sprintf( strbuf, "%c[f", 27 ); // ESC=27, Move cursor to upper-left corner = [f
    sendSerial(strbuf);
}

/*******************************************************************************
 menuRedraw - Write menu to terminal
*******************************************************************************/
// clears terminal and re-draws main menu
void menuRedraw(bool prompt){
    clrScrn();
    menu_banner();
    
    sprintf( strbuf, "%c[34m", 27 ); // ESC=27, Blue Text
    sendSerial(strbuf);
    
    sprintf(strbuf, "                                Agility Power Systems DCM1 v1.0 LUT v%1.1f\r\n\r\n", LUT_VER);
    sendSerial(strbuf);
    
    sprintf( strbuf, "%c[0m", 27 ); // ESC=27, Normal
    sendSerial(strbuf);
    sprintf( strbuf, "%c[30m", 27 ); // ESC=27, Black Text
    sendSerial(strbuf);
    
    struct adcValues adcVals = getADCresults();
    struct statusValues statVals = checkLevels(adcVals);
    refreshStatus(statVals);
    refreshData(adcVals);
    
    sprintf(strbuf, "\r\nCommands: (Not Case-Sensitive)");
    sendSerial(strbuf);
    sprintf(strbuf, "\r\n MENU");
    sendSerial(strbuf);
    sprintf(strbuf, "\r\n BRDS");
    sendSerial(strbuf);
    sprintf(strbuf, "\r\n MULT");
    sendSerial(strbuf);
    sprintf(strbuf, "\r\n ALLOFF");
    sendSerial(strbuf);
    sprintf(strbuf, "\r\n RUN");
    sendSerial(strbuf);
    sprintf(strbuf, "\r\n STOP\r\n");
    sendSerial(strbuf);
    sprintf(strbuf, "\r\n Type \'=number\' after BRDS or MULT to enter value.");
    sendSerial(strbuf);
    sprintf(strbuf, "\r\n e.g. BRDS=4095 will enable all boards.\r\n");
    sendSerial(strbuf);
    sprintf(strbuf, "\r\n Type \'?\' at end of BRDS or MULT to get status.");
    sendSerial(strbuf);
    sprintf(strbuf, "\r\n e.g. BRDS? will print value of BRDS.\r\n");
    sendSerial(strbuf);
    
    if(prompt){
        menuPrompt(MENU_DCM1);
    }
}

/*******************************************************************************
 sendLevelsWarning
*******************************************************************************/
void sendLevelsWarning(void){
    sprintf(strbuf, "\r\nSome voltage levels are out of range. I would look into it if I were you.\r\n");
    sendSerial(strbuf);
}

/*******************************************************************************
 menuPrompt - Write menu prompt to terminal
*******************************************************************************/
// sends carriage return and linefeed and prompt character
void menuPrompt(int menuType)
{
 char strMenu[30] ={0};

    switch(menuType)
    {
      case  MENU_DCM1: strcpy(strMenu,"DCM1"); break;
      case  MENU_CALIBRATE: strcpy(strMenu,"CAL"); break;
      case  MENU_TEST: strcpy(strMenu,"TEST"); break;
      case  MENU_MAIN: strcpy(strMenu,"MAIN"); break;
      default: strcpy(strMenu,"UNDF"); break;
    }

    // append the CR,LF and the ready character
     if(serialStatus.computer)
     {
         sendSerial("\r");
     }
     else
     {
        // adds a carrot so you know you are talking in terminal
        sprintf(strbuf,"\n\r%s>",strMenu);
        sendSerial(strbuf);
        // sendSerial("\n\r>");
     }
}

void menu_banner(void)
{
    clrScrn();
    sprintf( strbuf, "%c[30m", 27 ); // ESC=27, Black Text
    sendSerial(strbuf);
    sprintf(strbuf,"    ___         _ ___ __           ____                             _____            __                     \r\n");sendSerial(strbuf);
    sprintf(strbuf,"   /   | ____ _(_) (_) /___  __   / __ \\____ _      _____  _____   / ___/__  _______/ /____  ____ ___  _____\r\n");sendSerial(strbuf);
    sprintf(strbuf,"  / /| |/ __ `/ / / / __/ / / /  / /_/ / __ \\ | /| / / _ \\/ ___/   \\__ \\/ / / / ___/ __/ _ \\/ __ `__ \\/ ___/\r\n");sendSerial(strbuf);
    sprintf(strbuf," / ___ / /_/ / / / / /_/ /_/ /  / ____/ /_/ / |/ |/ /  __/ /      ___/ / /_/ (__  ) /_/  __/ / / / / (__  ) \r\n");sendSerial(strbuf);
    sprintf(strbuf,"/_/  |_\\__, /_/_/_/\\__/\\__, /  /_/    \\____/|__/|__/\\___/_/      /____/\\__, /____/\\__/\\___/_/ /_/ /_/____/  \r\n");sendSerial(strbuf);
    sprintf(strbuf,"      /____/          /____/                                          /____/                                \r\n");sendSerial(strbuf);
}
/*
    sprintf(strbuf,"    ___         _ ___ __           ____                             _____            __                     \r\n");
    sprintf(strbuf,"   /   | ____ _(_) (_) /___  __   / __ \____ _      _____  _____   / ___/__  _______/ /____  ____ ___  _____\r\n");
    sprintf(strbuf,"  / /| |/ __ `/ / / / __/ / / /  / /_/ / __ \ | /| / / _ \/ ___/   \__ \/ / / / ___/ __/ _ \/ __ `__ \/ ___/\r\n");
    sprintf(strbuf," / ___ / /_/ / / / / /_/ /_/ /  / ____/ /_/ / |/ |/ /  __/ /      ___/ / /_/ (__  ) /_/  __/ / / / / (__  ) \r\n");
    sprintf(strbuf,"/_/  |_\__, /_/_/_/\__/\__, /  /_/    \____/|__/|__/\___/_/      /____/\__, /____/\__/\___/_/ /_/ /_/____/  \r\n");
    sprintf(strbuf,"      /____/          /____/                                          /____/                                \r\n");
*/