//-------------------------------------------------------------------------------
// 
//  Treehouse Designs Inc.
//  Colorado Springs, Colorado
// 
//  Copyright (c) 2016 by Treehouse Designs Inc. 
//  Copyright (c) 2018 by Agility Power Systems Inc. 
// 
//  This code is the property of Treehouse Designs, Inc. (Treehouse) and
//  Agility Power Systems Inc. (Agility) and may not be redistributed
//  in any form without prior written permission from 
//  both copyright holders, Treehouse and Agility.
//
//  The above copyright notice and this permission notice shall be included in
//  all copies or substantial portions of the Software.
// 
//   
//-------------------------------------------------------------------------------
// 
//  REVISION HISTORY:
//  
//   $Author: $
//   $Rev: $
//   $Date: $
//   $URL: $
// 
//-------------------------------------------------------------------------------

#include "mbed.h"
#include "adc_defs.h"
#include "adc.h"
#include "all_io.h"

void initADC(void){
    
    //Auto-zero current values
    struct adcValues adcVals = getADCresults();
    
    CURRENT_12_OFFSET = adcVals.i12;
    
}

/*******************************************************************************
 getADCresults
*******************************************************************************/
struct adcValues getADCresults(void){
    
    double v48x = 0; 
    double v12x = 0;
    double i12x = 0;
    double test_vx = 0;
    
    struct adcValues avals;
    unsigned int loopCounter = LOOP_COUNTER;
    
    for(unsigned int i=0;i<loopCounter;i++){
        v48x = v48x + VIN48.read_u16();
        v12x = v12x + VIN12.read_u16();
        i12x = i12x + IIN12.read_u16();
        test_vx = test_vx + TESTERPIN.read_u16();
    }
    avals.test_v = test_vx/loopCounter;
    avals.v48 = v48x/loopCounter; 
    avals.v12 = v12x/loopCounter;
    avals.i12 = i12x/loopCounter;
    
    return avals;
}

/*******************************************************************************
 getADCvolts
*******************************************************************************/
struct adcValues getADCvolts(void){
    
    unsigned int v48x = 0; 
    unsigned int v12x = 0;
    unsigned int test_vx = 0;
    
    struct adcValues avals;
    
    for(unsigned int i=0;i<100;i++){
        v48x = v48x + VIN48.read_u16();
        v12x = v12x + VIN12.read_u16();
        test_vx = test_vx + TESTERPIN.read_u16();
    }
    avals.test_v = test_vx/100;
    avals.v48 = v48x/100; 
    avals.v12 = v12x/100;
    
    return avals;
}

/*******************************************************************************
 getADCamps
*******************************************************************************/
struct adcValues getADCamps(void){
    
    unsigned int i12x = 0;
    
    struct adcValues avals;
    
    for(unsigned int i=0;i<100;i++){
        i12x = i12x + IIN12.read_u16();
    }
    avals.i12 = i12x/100;
    
    return avals;
}

/*******************************************************************************
 calcDisplayValues
*******************************************************************************/
struct displayValues calcDisplayValues(struct adcValues avals){
    
    struct displayValues dvals;
    
    if(!raw){
        dvals.v48f = VOLTAGE_48_FACTOR*avals.v48;
        dvals.v12f = VOLTAGE_12_FACTOR*avals.v12;
        //dvals.i48f = ((avals.i48-CURRENT_48_OFFSET)/CURRENT_48_DIV_FACTOR)-CURRENT_CONTROL_OFFSET;
        
        // The adc results are linear above CURRENT_48_DIV_THRESH5. Only apply a linear correction to it above that threshold.
        // The multiple correction factors below CURRENT_48_DIV_THRESH5 linearize the curve below CURRENT_48_DIV_THRESH5.
        /*if(abs((avals.i48-CURRENT_48_OFFSET)) > CURRENT_48_DIV_THRESH5){
            dvals.i48f = (avals.i48-CURRENT_48_OFFSET)/CURRENT_48_DIV_FACTOR5;
        }else if(abs((avals.i48-CURRENT_48_OFFSET)) > CURRENT_48_DIV_THRESH4){
            dvals.i48f = (avals.i48-CURRENT_48_OFFSET)/CURRENT_48_DIV_FACTOR4;
        }else if(abs((avals.i48-CURRENT_48_OFFSET)) > CURRENT_48_DIV_THRESH3){
            dvals.i48f = (avals.i48-CURRENT_48_OFFSET)/CURRENT_48_DIV_FACTOR3;
        }else if(abs((avals.i48-CURRENT_48_OFFSET)) > CURRENT_48_DIV_THRESH2){
            dvals.i48f = (avals.i48-CURRENT_48_OFFSET)/CURRENT_48_DIV_FACTOR2;
        }else if(abs((avals.i48-CURRENT_48_OFFSET)) > CURRENT_48_DIV_THRESH1){
            dvals.i48f = (avals.i48-CURRENT_48_OFFSET)/CURRENT_48_DIV_FACTOR1;
        }else{
            dvals.i48f = (avals.i48-CURRENT_48_OFFSET)/CURRENT_48_DIV_FACTOR0;
        }
        
        dvals.i24f = (avals.i24-CURRENT_24_OFFSET)/CURRENT_24_DIV_FACTOR;
        */
        // The adc results are linear above CURRENT_12_DIV_THRESH5. Only apply a linear correction to it above that threshold.
        // The multiple correction factors below CURRENT_12_DIV_THRESH5 linearize the curve below CURRENT_12_DIV_THRESH5.
        if(abs((avals.i12-CURRENT_12_OFFSET)) > CURRENT_12_DIV_THRESH5){
            dvals.i12f = (avals.i12-CURRENT_12_OFFSET)/CURRENT_12_DIV_FACTOR5;
        }else if(abs((avals.i12-CURRENT_12_OFFSET)) > CURRENT_12_DIV_THRESH4){
            dvals.i12f = (avals.i12-CURRENT_12_OFFSET)/CURRENT_12_DIV_FACTOR4;
        }else if(abs((avals.i12-CURRENT_12_OFFSET)) > CURRENT_12_DIV_THRESH3){
            dvals.i12f = (avals.i12-CURRENT_12_OFFSET)/CURRENT_12_DIV_FACTOR3;
        }else if(abs((avals.i12-CURRENT_12_OFFSET)) > CURRENT_12_DIV_THRESH2){
            dvals.i12f = (avals.i12-CURRENT_12_OFFSET)/CURRENT_12_DIV_FACTOR2;
        }else if(abs((avals.i12-CURRENT_12_OFFSET)) > CURRENT_12_DIV_THRESH1){
            dvals.i12f = (avals.i12-CURRENT_12_OFFSET)/CURRENT_12_DIV_FACTOR1;
        }else{
            dvals.i12f = (avals.i12-CURRENT_12_OFFSET)/CURRENT_12_DIV_FACTOR0;
        }
        dvals.test_v = VOLTAGE_12_FACTOR*avals.test_v;
    }else{
        //dvals.v48f = 1.0*avals.v48-CURRENT_CONTROL_OFFSET;
        dvals.v48f = 1.0*avals.v48;
        dvals.v12f = 1.0*avals.v12;
        dvals.i12f = 1.0*avals.i12;
        dvals.test_v = 1.0*avals.test_v;
    }
    return dvals;
}