#include "MorseGenerator.h"


MorseGenerator::MorseGenerator(callback_type _callback) {
    generate_morse_map();
    callback = _callback;
}

void MorseGenerator::generate_morse_map() {
    add_mappings("ABCDEFGHIJKLMNOPQRSTUVWXYZ", MORSE_LETTERS);  
    add_mappings("1234567890", MORSE_NUMBERS);
}

void MorseGenerator::add_mappings(string morse_chars, const string morse_codes[]) {
    for (int i=0; i < morse_chars.length(); i++) {
        morse_map.insert(MapType::value_type(morse_chars[i], morse_codes[i]));
    }
}

void MorseGenerator::transmit(string message) {
    for (int i=0; i < message.length(); i++) {
        if (strncmp(&message[i], " ", 1) != 0) {
            transmit(message[i]);                
        }
        wait_ms(DIT_MS * 7);
    }
}

void MorseGenerator::transmit(char letter) {
    int d;
    string code = morse_map[letter];

    for (int i=0; i < code.length(); i++) {
        if (strncmp(&code[i], ".", 1) == 0) {
            d = 1;
        } else {
            d = 3;
        }
        callback(1);
        wait_ms(DIT_MS * d);
        callback(0);
        wait_ms(DIT_MS);
    }
}