#include <map>
#include <string>
#include "mbed.h"

#define DIT_MS 100


using namespace std;

typedef map <char, string> MapType;
typedef void (*callback_type)(int);

const string MORSE_LETTERS[] = {".-", "-...", "-.-.", "-..", ".", "..-.", "--.", "....", "..", ".---", "-.-", ".-..", "--", "-.", "---", ".--.", "--.-", ".-.", "...", "-", "..-", "...-", ".--", "-..-", "-.--", "--.."};
const string MORSE_NUMBERS[] = {".----", "..---", "...--", "....-", ".....", "-....", "--...", "---..", "----.", "-----"};

/** MorseGenerator class.
 *
 * Example:
 * @code
 * #include "mbed.h"
 * #include "morsegenerator.h"
 *
 * DigitalOut myled(p18);
 *
 * void morse_callback(int val) {
 *     myled = val;
 * }
 *
 * int main() {
 *     MorseGenerator morse = MorseGenerator(morse_callback);
 *
 *     while (1) {
 *         morse.transmit("CQCQ DE M6SPX");
 *     }
 * }
 * @endcode
 */
class MorseGenerator {
    MapType morse_map;
    callback_type callback;

    void generate_morse_map();
    void add_mappings(string morse_chars, const string morse_codes[]);
public:
    /** Create a MorseGenerator that calls a specific callback
     *
     * @param callback called when turning on or off.
     */
    MorseGenerator(callback_type callback);

    /** transmit a string
     *
     * @param message to transmit.
     */
    void transmit(string message);

    /** transmit a char
     *
     * @param char to transmit.
     */
    void transmit(char letter);
};