#include "mbed.h"
#include "Serial.h"

#define SERIAL_TX P0_10
#define SERIAL_RX P0_11
#define LEDStick P0_22

Serial pc(SERIAL_TX, SERIAL_RX);
DigitalOut myled(LEDStick);

void Rx_interrupt();


// Circular buffers for serial TX and RX data - used by interrupt routines
const int buffer_size = 255;
// might need to increase buffer size for high baud rates
//char tx_buffer[buffer_size+1];
char rx_buffer[buffer_size+1];
// Circular buffer pointers
// volatile makes read-modify-write atomic 
//volatile int tx_in=0;
//volatile int tx_out=0;
volatile int rx_in=0;
volatile int rx_out=0;
// Line buffers for sprintf and sscanf
//char tx_line[80];
//char rx_line[80];
 
int main() {

  pc.baud(9600);
  pc.format(8,Serial::None,1);
  
  // Setup a serial interrupt function to receive data
    pc.attach(&Rx_interrupt, Serial::RxIrq);
  
  pc.printf("Hello World !\n");
  while(1)
  { 
      
      if(rx_in)
      {
          pc.printf("%c",rx_buffer[rx_out]);
          rx_out++;
          if(rx_in==rx_out)
          {
            rx_in=0;
            rx_out=0;
            }
        }
}
}



// Interupt Routine to read in data from serial port
void Rx_interrupt()
{
        if(pc.readable())
        {
            rx_buffer[rx_in] = pc.getc();
            rx_in++;
        }
        if(rx_in==buffer_size)
            pc.printf("Buffer excedido");
    return;
}