#include "QEI.h"

Serial pc(USBTX, USBRX);

#define ROTATE_PER_REVOLUTIONS  500
//Use X4 encoding.
QEI wheel(dp17, dp18, dp26, ROTATE_PER_REVOLUTIONS, QEI::X4_ENCODING);
//Use X2 encoding by default.
//QEI wheel (p30, p29, NC, 624);

int main() {
    while(1){
        wait(0.1);
        //pc.printf("Pulses: %07d\n", wheel.getPulses());
        pc.printf("Rotate: %04.3f\r\n", (double)wheel.getPulses()/(ROTATE_PER_REVOLUTIONS*4));
    }
}