#ifndef __AHRSMATHDSP_VECTOR3_
#define __AHRSMATHDSP_VECTOR3_

//#include "arm_math.h"

class Vector3
{
public:
    Vector3() : x(0.0f), y(0.0f), z(0.0f) {}

    Vector3(float const _x, float const _y, float const _z)
        : x(_x), y(_y), z(_z) {}

    void set(float const _x, float const _y, float const _z) {
        x = _x;
        y = _y;
        z = _z;
    }

    float length_squared() const {
        return x * x + y * y + z * z;
    }

    float length() const {
        return sqrt(length_squared());
    }

    void normalise() {
        float const len = length();
        x = x / len;
        y = y / len;
        z = z / len;
    }

    Vector3 normalised() const {
        return *this / length();
    }

    float dot_product(const Vector3 &v) const {
        return x * v.x + y * v.y + z * v.z;
    }

    Vector3 cross_product(const Vector3 &v) const {
        Vector3 temp(y * v.z - z * v.y, z * v.x - x * v.z, x * v.y - y * v.x);
        return temp;
    }

    // operator overides
    void operator()(const float _x, const float _y, const float _z) {
        x = _x;
        y = _y;
        z = _z;
    }

    bool operator==(const Vector3 &v) const {
        return (x == v.x && y == v.y && z == v.z);
    }

    bool operator!=(const Vector3 &v) const {
        return (x != v.x || y != v.y || z != v.z);
    }

    const Vector3 &operator=(const Vector3 &v) {
        x = v.x;
        y = v.y;
        z = v.z;
        return *this;
    }

    const Vector3 operator-(void) const {
        return Vector3(-x, -y, -z);
    }

    const Vector3 operator+(const Vector3 &v) const {
        return Vector3(x + v.x, y + v.y, z + v.z);
    }

    const Vector3 operator-(const Vector3 &v) const {
        return Vector3(x - v.x, y - v.y, z - v.z);
    }

    const Vector3 operator*(const float num) const {
        return Vector3(x * num, y * num, z * num);
    }

    const Vector3 operator/(const float num) const {
        return Vector3(x / num, y / num, z / num);
    }

    float operator*(const Vector3 &v) const {
        return x * v.x + y * v.y + z * v.z;
    }

    float x, y, z;
};

#endif