/**
    LPC1768 adalah program display noritake yang digabungkan dengan
    pogram i2c to serial SC16IS752.
**/

#include "mbed.h"
#include "query.h"
#include "Katakata.h"
#include <sstream>
#include <vector>

DigitalOut myled(LED1);
Serial dbg(USBTX, USBRX);
Noritake_VFD_GU7000 vfd(p28, p27);

void Display_init()
{
    vfd.GU7000_cursorOff();
    vfd.GU7000_clearScreen();
}

void Main_Menu()
{
    vector<uint8_t> Vdat;
    
    Vdat.insert(Vdat.begin(), invertOn, invertOn+sizeof(invertOn));
    for(int i=0; i<strlen(MMe); i++)
        Vdat.push_back((uint8_t) MMe[i]);
    Vdat.insert(Vdat.end(), invertOff, invertOff+sizeof(invertOff));
    
    Vdat.insert(Vdat.end(), invertOn, invertOn+sizeof(invertOn));
    for(int i=0; i<strlen(Sat); i++)
        Vdat.push_back((uint8_t) Sat[i]);
    Vdat.insert(Vdat.end(), invertOff, invertOff+sizeof(invertOff));
    for(int i=0; i<strlen(Ent); i++)
        Vdat.push_back((uint8_t) Ent[i]);
        
    Vdat.insert(Vdat.end(), invertOn, invertOn+sizeof(invertOn));
    for(int i=0; i<strlen(Dua); i++)
        Vdat.push_back((uint8_t) Dua[i]);
    Vdat.insert(Vdat.end(), invertOff, invertOff+sizeof(invertOff));
    for(int i=0; i<strlen(Exi); i++)
        Vdat.push_back((uint8_t) Exi[i]);
        
    Vdat.insert(Vdat.end(), invertOn, invertOn+sizeof(invertOn));
    for(int i=0; i<strlen(Tig); i++)
        Vdat.push_back((uint8_t) Tig[i]);
    Vdat.insert(Vdat.end(), invertOff, invertOff+sizeof(invertOff));
    for(int i=0; i<strlen(SCo); i++)
        Vdat.push_back((uint8_t) SCo[i]);
        
    Vdat.insert(Vdat.end(), invertOn, invertOn+sizeof(invertOn));
    for(int i=0; i<strlen(Emp); i++)
        Vdat.push_back((uint8_t) Emp[i]);
    Vdat.insert(Vdat.end(), invertOff, invertOff+sizeof(invertOff));
    for(int i=0; i<strlen(SKe); i++)
        Vdat.push_back((uint8_t) SKe[i]);
        
    Vdat.insert(Vdat.end(), invertOn, invertOn+sizeof(invertOn));
    for(int i=0; i<strlen(Lim); i++)
        Vdat.push_back((uint8_t) Lim[i]);
    Vdat.insert(Vdat.end(), invertOff, invertOff+sizeof(invertOff));
    for(int i=0; i<strlen(MDa); i++)
        Vdat.push_back((uint8_t) MDa[i]);
    
    uint8_t tmp[128];
    copy(Vdat.begin(), Vdat.end(), tmp);
    const uint8_t* data = tmp;
    vfd.print(data, Vdat.size());
    Vdat.clear();
}

int PreMenu = 0; // 0=Main Menu; 1=Entrance; 2=Exit; 3=Set Config; 4=Set Key; 5=Mode Data
void Sub_Menu(int Menu)
{
    if(Menu != PreMenu)
    {
        vfd.GU7000_clearScreen();
        PreMenu = Menu;
    }
    
    if(Menu == 0)
    {
        Main_Menu();
    }
    
    vector<uint8_t> dat;
    
    // Set Header
    switch(Menu)
    {
        case 0: break;
        case 1: dat.insert(dat.begin(), invertOn, invertOn+sizeof(invertOn));
                for(int i=0; i<strlen(MEn); i++)
                    dat.push_back((uint8_t) MEn[i]);
                dat.insert(dat.end(), invertOff, invertOff+sizeof(invertOff));
                break;
                
        case 2: dat.insert(dat.begin(), invertOn, invertOn+sizeof(invertOn));
                for(int i=0; i<strlen(MEx); i++)
                    dat.push_back((uint8_t) MEx[i]);
                dat.insert(dat.end(), invertOff, invertOff+sizeof(invertOff));
                break;
                
        case 3: dat.insert(dat.begin(), invertOn, invertOn+sizeof(invertOn));
                for(int i=0; i<strlen(MKo); i++)
                    dat.push_back((uint8_t) MKo[i]);
                dat.insert(dat.end(), invertOff, invertOff+sizeof(invertOff));
                break;
                
        case 4: dat.insert(dat.begin(), invertOn, invertOn+sizeof(invertOn));
                for(int i=0; i<strlen(Set); i++)
                    dat.push_back((uint8_t) Set[i]);
                dat.insert(dat.end(), invertOff, invertOff+sizeof(invertOff));
                break;
                
        case 5: dat.insert(dat.begin(), invertOn, invertOn+sizeof(invertOn));
                for(int i=0; i<strlen(Mod); i++)
                    dat.push_back((uint8_t) Mod[i]);
                dat.insert(dat.end(), invertOff, invertOff+sizeof(invertOff));
                dat.push_back('\n');
                break;
                
        case 6: dat.insert(dat.begin(), invertOn, invertOn+sizeof(invertOn));
                for(int i=0; i<strlen(Mod); i++)
                    dat.push_back((uint8_t) Mod[i]);
                dat.insert(dat.end(), invertOff, invertOff+sizeof(invertOff));
                for(int i=0; i<strlen(His); i++)
                    dat.push_back((uint8_t) His[i]);
                break;
    }
    
    if(Menu != 0)
    {
        for(int i=0; i<strlen(Mas); i++)
            dat.push_back((uint8_t) Mas[i]);    
    }
    
    // Set Body
    switch(Menu)
    {
        case 0: break;
        case 1: 
        case 2: for(int i=0; i<strlen(PAS); i++)
                    dat.push_back((uint8_t) PAS[i]);
                break;
                
        case 3: 
        case 4: for(int i=0; i<strlen(MTN); i++)
                    dat.push_back((uint8_t) MTN[i]);
                break;
                
        case 5: for(int i=0; i<strlen(PUL); i++)
                    dat.push_back((uint8_t) PUL[i]);
                break;
                
        case 6: for(int i=0; i<strlen(ENT); i++)
                    dat.push_back((uint8_t) ENT[i]);
                break;
    }
    
    // Set Footer
    switch(Menu)
    {
        case 0: break;
        case 6:
        case 1:
        case 2:
        case 3:
        case 4: dat.insert(dat.end(), invertOn, invertOn+sizeof(invertOn));
                for(int i=0; i<strlen(Noo); i++)
                    dat.push_back((uint8_t) Noo[i]);
                dat.insert(dat.end(), invertOff, invertOff+sizeof(invertOff));
                for(int i=0; i<strlen(Bat); i++)
                    dat.push_back((uint8_t) Bat[i]);
                break;
                
        case 5: dat.insert(dat.end(), invertOn, invertOn+sizeof(invertOn));
                for(int i=0; i<strlen(Yes); i++)
                    dat.push_back((uint8_t) Yes[i]);
                dat.insert(dat.end(), invertOff, invertOff+sizeof(invertOff));
                for(int i=0; i<strlen(Lan); i++)
                    dat.push_back((uint8_t) Lan[i]);
                dat.insert(dat.end(), invertOn, invertOn+sizeof(invertOn));
                for(int i=0; i<strlen(Noo); i++)
                    dat.push_back((uint8_t) Noo[i]);
                dat.insert(dat.end(), invertOff, invertOff+sizeof(invertOff));
                for(int i=0; i<strlen(Bat); i++)
                    dat.push_back((uint8_t) Bat[i]);
                break;
    }
    
    uint8_t tmp[128];
    copy(dat.begin(), dat.end(), tmp);
    const uint8_t* data = tmp;
    vfd.print(data, dat.size());
    dat.clear();
    
    dbg.printf("Switch Menu is done\r\n");
}

DigitalOut led(LED1);
Ticker run;
void runled()
{
    led =! led;
}

int main()
{
    run.attach(&runled, 0.5);
    Display_init();
    Main_Menu();
    set_time(1256729737);
    while(1)
    {
        time_t t = time(NULL);
        char buf[32];
        strftime(buf, 32, "%d/%m/%y %H:%M:%S", localtime(&t));
        vfd.printAt(1, 8, buf);
        
        vfd.GU7000_drawImageAt(122, 56, 6, 8, sym);
    }
    
}
