#ifndef LOKERFRAME_H
#define LOKERFRAME_H

#include <vector>
#include <queue>

class LokerFrm;

//----------------------------------------------------------------
class LokerFraming
{
public:
    LokerFraming();
    ~LokerFraming();

    void ProcessFromHost(const std::vector<int> &stream);

    static std::vector<int> CreateFrame(const LokerFrm &f);

    std::queue<LokerFrm> RCV_QUE;

private:
	
};

//----------------------------------------------------------------
class LokerFrm
{
public:

    int stx;
	int status;
//    int zData;
    std::vector<int> Data;
	int ceksum;
	int etx;
};

//----------------------------------------------------------------
class TxFrm : public LokerFrm
{
public:
	TxFrm(std::vector<int> &Data_, int status_)
	{
		stx = 0x32;
		status = status_;
		Data = Data_;
		ceksum = -1;
		etx = 0x33;
	}
};
#endif //LOKERFRAME_H
