#include "mbed.h"
#include "LokerFraming.h"

extern Serial dbg;

LokerFraming::LokerFraming()
{

}

LokerFraming::~LokerFraming()
{

}

void LokerFraming::ProcessFromHost(const std::vector<int> &stream)
{
    LokerFrm f;
	
	f.stx = stream[0];
	f.status = stream[1];
	f.Data.push_back(stream[2]);
	f.Data.push_back(stream[3]);
	f.etx = stream[4];
	RCV_QUE.push(f);
}

std::vector<int> LokerFraming::CreateFrame(const LokerFrm &f)
{
    std::vector<int> result;

    result.push_back(f.stx);
    result.push_back(f.status);
	for(int i=0; i<f.Data.size(); i++)
	{
		result.push_back(f.Data[i] & 0x0FF);
	}
	result.push_back(f.etx);
    return result;
}