//#include "mbed.h"
#include "EthernetInterface.h"
#include "CommChannel.h"
#include "const_defines.h"

extern Serial dbg;

//-----------------------------------------------------------------
extern std::vector<int> RCV_BUFF;   // temporary buffer receiving progress
std::vector<int> RCVD;       // buffer completed receiving

//-----------------------------------------------------------------
// Mechanism for receive timeout
//
extern int timerRxTOutCnt;

//-----------------------------------------------------------------
//  TCP definition
//
extern TCPSocketConnection socket;

//-----------------------------------------------------------------
//  Wrapper class
//
CommChannel::CommChannel()
{
//    dbg.printf("<CommChannel>");
}

CommChannel::~CommChannel()
{

}

void CommChannel::connect(const std::string &host)
{
    // Connect to Server
    int timeout = 0;
    while (socket.connect(host.c_str(), 5002) < 0) {
        dbg.printf(RED"Unable to connect to (%s) on port (%d)\r\n"DEF, host.c_str(), 5002);
        timeout++;
        if(timeout > 60)break;
        wait(1);
    }
}

int CommChannel::dataAvailable()
{
    return RCVD.size();
}

std::vector<int> CommChannel::read()
{
    std::vector<int> result;

    for(int i=0; i<RCVD.size(); i++)
        result.push_back(RCVD[i]);

    RCVD.clear();
    return result;
}

void CommChannel::write(const std::vector<int> &s)
{
    char sData[s.size()];
    
    for(int i=0; i<s.size(); i++)
    {
        sData[i] = s[i] & 0x0ff;
    }
    
    socket.send_all(sData, sizeof(sData));
}

void CommChannel::write(char *s, int sz)
{   
    socket.send_all(s, sz);
}

void CommChannel::Tick10ms()
{
    timerRxTOutCnt++;
    if(timerRxTOutCnt >= 10)
    {
        timerRxTOutCnt = 0;
        
        if(RCV_BUFF.size() > 0)
        {
            for(int i=0; i<RCV_BUFF.size(); i++)
            {
                RCVD.push_back(RCV_BUFF[i]);
//                dbg.printf("[%02X]", RCV_BUFF[i] & 0x0FF);
            } 
            RCV_BUFF.clear();
        }
    }    
}

//-----------------------------------------------------------------
