/*
    \\ library ini merupakan play audio menggunakan PWM dan buzzer
    \\ terinspirasi dari https://developer.mbed.org/users/4180_1/notebook/using-a-speaker-for-audio-output/
*/

#ifndef AUDIO_H
#define AUDIO_H

#include "mbed.h"

class Audio
{
public:
    Audio(PinName buzzer);
    
    /*
        \\ Set Volume digunakan untuk menentukan Volume dari buzzer
        \\ Parameter volume bernilai 0.0 - 2.0
        \\ 0.0 untuk mute dan 2.0 untuk full
    */
    void SetVolume(double volume=0.5f);
    
    /*
        \\ SetDuration digunakan untuk menentukan lamanya buzzer bunyi dalam satu siklus
        \\ Parameter menggunakan tipe bilangan bulat dalam orde mili sekon
    */
    void SetDuration(unsigned int milisec=1000);
    
    /*
        \\ PlayNote digunakan untuk membunyikan buzzer sesuai dengan nada,
        \\ Nada yang digunakan merupakan nada dasar do sampai si dengan c=do
        \\ parameter angka merupakan perwujudan nada 0=diam, 1=do, 2=re, 3=mi, dst
    */
    void PlayNote(unsigned int angka);
    
    /*
        \\ PlayNote digunakan untuk membunyikan buzzer sesuai dengan nada,
        \\ dimainkan dalam not huruf
        \\ parameter huruf berupa const char * karena dapat 
    */
//    void PlayNote(const char * huruf);
    
    void PlayNote(double frequency, double duration, double volume);
    
    void mute();
private:
    PwmOut out;
    double vol;
    int ms;
};

#endif // AUDIO_H