#include "mbed.h"
#include "VL6180X.h"
#include "STMPE1600.h"
#include "Display.h"
#include "Switch.h"






#ifdef TEST_LCD
LCD tft(LCD_SPI_CS,LCD_SPI_DC, LCD_MOSI_PIN, LCD_MISO_PIN, LCD_SPI_CL_PIN,LCD_BL_PIN);
#else
#define LCD int
LCD tft;
#endif


#if __TT_M3HQ__
#define DISPLAY_TMPM_STRING "Welcome to Thundersoft TT_M3HQ"
#endif


#if __TT_M4G9__
#define DISPLAY_TMPM_STRING "Welcome to Thundersoft TT_M4G9"
#endif




#define DISPLAY_VL6180_ID_STRING "VL6180 ID:"
#define DISPLAY_VL6180_ID_HIGH   (16 * 1)
#define DISPLAY_STEMPE_STRING "STMPE ID:"
#define DISPLAY_STEMPE_ID_HIGH        (DISPLAY_VL6180_ID_HIGH * 2)
#define DISPLAY_VL6180_RANGE_VALUE_STRING "VL6180X RANG:"
#define DISPLAY_VL6180_RANGE_STRING_HIGH   (DISPLAY_VL6180_ID_HIGH * 3)
#define DISPLAY_VL6180_RANGE_VALUE_HIGH   (DISPLAY_VL6180_ID_HIGH * 4)
#define DISPLAY_VL6180_ALS_VALUE_STRING   "VL6180X ALS:"
#define DISPLAY_VL6180_ALS_STRING_HIGH    (DISPLAY_VL6180_ID_HIGH * 5)
#define DISPLAY_VL6180_ALS_VALUE_HIGH     (DISPLAY_VL6180_ID_HIGH * 6)




static void displayForVL6180X(LCD &lcd,VL6180X &vl6180x,STMPE1600 &stmpe1600)
{
#ifdef TEST_LCD
  char temp_buffer[5];
  temp_buffer[4] = '\0';
  lcd.drawString(0,0,DISPLAY_TMPM_STRING,RED);

  lcd.drawString(0,DISPLAY_VL6180_ID_HIGH,DISPLAY_VL6180_ID_STRING,RED);
  translateBinaryToBCD(temp_buffer,vl6180x.readID());
  lcd.drawString((sizeof(DISPLAY_VL6180_ID_STRING) - 1) * FONT_CHAR_WIDTH,DISPLAY_VL6180_ID_HIGH,(const char *)temp_buffer,BLACK);

  displayId(lcd,DISPLAY_STEMPE_STRING,sizeof(DISPLAY_STEMPE_STRING),DISPLAY_STEMPE_ID_HIGH,stmpe1600.readID());

  /*Set 6180XA1 for LCD string*/
  lcd.drawString(0,DISPLAY_VL6180_RANGE_STRING_HIGH,DISPLAY_VL6180_RANGE_VALUE_STRING,RED);
  lcd.drawString(0,DISPLAY_VL6180_ALS_STRING_HIGH,DISPLAY_VL6180_ALS_VALUE_STRING,RED);
#endif
}

static void handleLCDForVL6180X(LCD &lcd,VL6180X &vl6180x)
{
  char temp_buffer[50];
  while(1)
  {
    /*data for range */
    memset(temp_buffer,0,sizeof(temp_buffer));
    sprintf(temp_buffer,"%d",vl6180x.readRangeSingle());
#ifdef TEST_LCD
    lcd.drawString(0,DISPLAY_VL6180_RANGE_VALUE_HIGH,temp_buffer,RED);
#endif
    printf("Range = %d \r\n",vl6180x.readRangeSingle());
    /*data for als*/
    memset(temp_buffer,0,sizeof(temp_buffer));
    sprintf(temp_buffer,"%d",vl6180x.readAmbientSingle());
#ifdef TEST_LCD
    lcd.drawString(0,DISPLAY_VL6180_ALS_VALUE_HIGH,temp_buffer,RED);
#endif
    printf("ALS = %d \r\n",vl6180x.readAmbientSingle());
    wait_ms(1000);
#ifdef TEST_LCD
    lcd.clearScreenArea(0,DISPLAY_VL6180_RANGE_VALUE_HIGH,WHITE);
    lcd.clearScreenArea(0,DISPLAY_VL6180_ALS_VALUE_HIGH,WHITE);
#endif
  }
}


int main()
{
    printf("%s\r\n",DISPLAY_TMPM_STRING);
    I2C *i2c =new I2C(D14,D15);
    VL6180X *vl6180x = new VL6180X(i2c);
    STMPE1600 *stmpe1600 = new STMPE1600(i2c);
    Display display(*stmpe1600);
    Switch  _switch(*stmpe1600);
    //MeasureData_t measure_data;
    vl6180x->init();
    vl6180x->configureDefault();
     //vl6180x->startAmbientContinuous();
    printf("Vl6180X ID = 0x%x \r\n",vl6180x->readID());
    printf("STMPE1600 ID = 0x%x \r\n",stmpe1600->readID());
#ifdef TEST_LCD
    tft.init();
#endif
    displayForVL6180X(tft,*vl6180x,*stmpe1600);
    handleLCDForVL6180X(tft,*vl6180x);
    while(1)
    {
    }
}