#include "DoorStatus.h"




#if defined(__TT_M4G9__)
#define DEFAULT_DOR_PIN PL0
#endif


#if defined(__TT_M3HQ__)
#define DEFAULT_DOR_PIN PK7
#endif


DoorStatus::DoorStatus()
{
     interruptPin = new InterruptIn(DEFAULT_DOR_PIN);
}

DoorStatus::DoorStatus(PinName pin)
{
    interruptPin = new InterruptIn(pin);
}

void DoorStatus::handleCallback(Callback<void()> func)
{
    interruptPin->fall(func);
}
