#include "PirSensor.h"



#if defined(__TT_M4G9__)
#define DEFAULT_DOR_PIN PK1
#endif


#if defined(__TT_M3HQ__)
#define DEFAULT_DOR_PIN PJ4
#endif


PirSensor::PirSensor()
{
     interruptPin = new InterruptIn(DEFAULT_DOR_PIN);
}

PirSensor::PirSensor(PinName pin)
{
    interruptPin = new InterruptIn(pin);
}

void PirSensor::handleCallback(Callback<void()> func)
{
    interruptPin->fall(func);
}
