#include "mbed.h"
#include "MPU6050.h"






#ifdef TEST_LCD
LCD tft(LCD_SPI_CS,LCD_SPI_DC, LCD_MOSI_PIN, LCD_MISO_PIN, LCD_SPI_CL_PIN,LCD_BL_PIN);
#else
#define LCD int
LCD tft;
#endif


#if __TT_M3HQ__
#define DISPLAY_TMPM_STRING "Welcome to Thundersoft TT_M3HQ"
#endif


#if __TT_M4G9__
#define DISPLAY_TMPM_STRING "Welcome to Thundersoft TT_M4G9"
#endif

/*macros for MPU6050 sensor*/
#define DISPLAY_MPU6050_ID_STRING "MPU6050 ID:"
#define DISPLAY_MPU6050_ID_STRING_HIGH 16
#define DISPLAY_MPU6050_ACC_STRING "MPU6050 ACC:"
#define DISPLAY_MPU6050_ACC_STRING_HIGH   32
#define DISPLAY_MPU6050_ACC_VALUE_HIGH   48
#define DISPLAY_MPU6050_MAG_STRING "MPU6050 MAG:"
#define DISPLAY_MPU6050_MAG_HIGH 64
#define DISPLAY_MPU6050_MAG_VALUE_HIGH 80


static void displayForMPU6050(LCD &lcd,MPU6050 &mpu6050)
{
#ifdef TEST_LCD
  lcd.drawString(0,0,DISPLAY_TMPM_STRING,RED);
  displayId(lcd,DISPLAY_MPU6050_ID_STRING,sizeof(DISPLAY_MPU6050_ID_STRING),DISPLAY_MPU6050_ID_STRING_HIGH,mpu6050.getDeviceID());
  lcd.drawString(0,DISPLAY_MPU6050_ACC_STRING_HIGH,DISPLAY_MPU6050_ACC_STRING,RED);
  lcd.drawString(0,DISPLAY_MPU6050_MAG_HIGH,DISPLAY_MPU6050_MAG_STRING,RED);
#endif
}

static void handleLCDForMPU6050(LCD &lcd,MPU6050 &mpu6050)
{
  uint16_t acc[3];
  uint16_t mag[3];
  char temp_buffer[50];
  while(1)
  {
    
    acc[0] = mpu6050.getX();
    acc[1] = mpu6050.getY();
    acc[2] = mpu6050.getZ();
    mag[0] = mpu6050.getGX();
    mag[1] = mpu6050.getGY();
    mag[2] = mpu6050.getGZ();
    memset(temp_buffer,0,sizeof(temp_buffer));
    sprintf(temp_buffer,"%d,%d,%d",acc[0],acc[1],acc[2]);
#ifdef TEST_LCD
    lcd.drawString(0,DISPLAY_MPU6050_ACC_VALUE_HIGH,temp_buffer,RED);
#endif
    printf("MPU6050 ACC data = %d,%d,%d \r\n",acc[0],acc[1],acc[2]);
    memset(temp_buffer,0,sizeof(temp_buffer));
    sprintf(temp_buffer,"%d,%d,%d",mag[0],mag[1],mag[2]);
#ifdef TEST_LCD
    lcd.drawString(0,DISPLAY_MPU6050_MAG_VALUE_HIGH,temp_buffer,RED);
#endif
    printf("MPU6050 MAG data = %d,%d,%d \r\n",mag[0],mag[1],mag[2]);
    wait_ms(1000);
#ifdef TEST_LCD
    lcd.clearScreenArea(0,DISPLAY_MPU6050_ACC_VALUE_HIGH,WHITE);
    lcd.clearScreenArea(0,DISPLAY_MPU6050_MAG_VALUE_HIGH,WHITE);
#endif
  }
}


int main()
{
  MPU6050 mp;
  printf("%s\r\n",DISPLAY_TMPM_STRING);
  printf("MPU6050 ID = 0x%x \r\n",mp.getDeviceID());
#ifdef TEST_LCD
  tft.init();
#endif
  displayForMPU6050(tft,mp);
  handleLCDForMPU6050(tft,mp);
  while(1)
  {
  }
}