#include "LCD.h"




char translateChar(char arg)
{
  if(arg > 9)
    return arg + 55;
  else
    return arg + 48;
}

void translateBinaryToBCD(char *arg,char Id)
{
  char high = (Id >> 4) & 0x0f;
  char low = Id & 0x0f;
  arg[0] = '0';
  arg[1] = 'x';
  arg[2] = translateChar(high);
  arg[3] = translateChar(low);
}

void displayId(HX8347 &lcd,char *string,int length,int high,char id)
{
  char temp_buffer[5];
  temp_buffer[4] = '\0';
  lcd.drawString(0,high,string,RED);
  translateBinaryToBCD(temp_buffer,id);
  lcd.drawString(length * FONT_CHAR_WIDTH,high,(const char *)temp_buffer,BLACK);
}