#include "mbed.h"
#include "IKS01A2.h"






#ifdef TEST_LCD
LCD tft(LCD_SPI_CS,LCD_SPI_DC, LCD_MOSI_PIN, LCD_MISO_PIN, LCD_SPI_CL_PIN,LCD_BL_PIN);
#else
#define LCD int
LCD tft;
#endif


#if __TT_M3HQ__
#define DISPLAY_TMPM_STRING "Welcome to Thundersoft TT_M3HQ"
#endif


#if __TT_M4G9__
#define DISPLAY_TMPM_STRING "Welcome to Thundersoft TT_M4G9"
#endif


/*macros for ISK01A2 shiled board*/
#define DISPLAY_LSM6DSL_ID_STRING   "LSM6DSL ID:"
#define DISPLAY_LSM6DSL_ID_HIGHT    16
#define DISPLAY_LSM303ACC_ID_STRING   "LSMACC ID:"
#define DISPLAY_LSM303ACC_ID_HIGHT  32
#define DISPLAY_LSM303MAG_ID_STRING   "LSMMAG ID:"
#define DISPLAY_LSM303MAG_ID_HIGHT  48
#define DISPLAY_HTS221_ID_STRING   "HTS221 ID:"
#define DISPLAY_HTS221_ID_HIGHT  64
#define DISPLAY_LPS22_ID_STRING   "LPS22 ID:"
#define DISPLAY_LPS22_ID_HIGHT  80
#define DISPLAY_LSM6DSL_ACC_VALUE_STRING "LSM6DSL X Axes:"
#define DISPLAY_LSM6DSL_ACC_VALUE_STRING_HIGHT  96
#define DISPLAY_LSM6DSL_ACC_VALUE_HIGHT  (DISPLAY_LSM6DSL_ACC_VALUE_STRING_HIGHT + FONT_CHAR_HEIGHT)
#define DISPLAY_LSM6DSL_MAG_VALUE_STRING "LSM6DSL G Axes:"
#define DISPLAY_LSM6DSL_MAG_VALUE_STRING_HIGHT  128
#define DISPLAY_LSM6DSL_MAG_VALUE_HIGHT         (DISPLAY_LSM6DSL_MAG_VALUE_STRING_HIGHT + FONT_CHAR_HEIGHT)
#define DISPLAY_LSM303AGR_ACC_VALUE_STRING "LSM303AGR:"
#define DISPLAY_LSM303AGR_ACC_VALUE_STRING_HIGH 160
#define DISPLAY_LSM303AGR_ACC_VALUE_HIGH        (DISPLAY_LSM303AGR_ACC_VALUE_STRING_HIGH + FONT_CHAR_HEIGHT)
#define DISPLAY_LSM303MAG_VALUE_STRING       "LSM303MAG:"
#define DISPLAY_LSM303MAG_VALUE_STRING_HIGH     192
#define DISPLAY_LSM303MAG_VALUE_HIGH            (DISPLAY_LSM303MAG_VALUE_STRING_HIGH + FONT_CHAR_HEIGHT)
#define DISPLAY_HTS221_VALUE_STRING          "HTS221:"
#define DISPLAY_HTS221_VALUE_STRING_HIGH     (DISPLAY_LSM303MAG_VALUE_HIGH + FONT_CHAR_HEIGHT)
#define DISPLAY_HTS221_VALUE_HIGH            (DISPLAY_HTS221_VALUE_STRING_HIGH + FONT_CHAR_HEIGHT)
#define DISPLAY_LPS22HB_VALUE_STRING         "LPS22HB:"
#define DISPLAY_LPS22HB_VALUE_STRING_HIGH    (DISPLAY_HTS221_VALUE_HIGH + FONT_CHAR_HEIGHT)
#define DISPLAY_LPS22HB_VALUE_HIGH           (DISPLAY_LPS22HB_VALUE_STRING_HIGH + FONT_CHAR_HEIGHT)




static void displayForIKS01A2(LCD &lcd,IKS01A2 &iks102)
{
#ifdef TEST_LCD
  char temp_buffer[5];
  temp_buffer[4] = '\0';
  lcd.drawString(0,0,DISPLAY_TMPM_STRING,RED);

  lcd.drawString(0,DISPLAY_LSM6DSL_ID_HIGHT,DISPLAY_LSM6DSL_ID_STRING,RED);
  translateBinaryToBCD(temp_buffer,iks102.getIdLSM6DSL());
  lcd.drawString((sizeof(DISPLAY_LSM6DSL_ID_STRING) - 1) * FONT_CHAR_WIDTH,DISPLAY_LSM6DSL_ID_HIGHT,(const char *)temp_buffer,BLACK);

  lcd.drawString(0,DISPLAY_LSM303ACC_ID_HIGHT,DISPLAY_LSM303ACC_ID_STRING,RED);
  translateBinaryToBCD(temp_buffer,iks102.getIdLSM303AGR());
  lcd.drawString((sizeof(DISPLAY_LSM303ACC_ID_STRING) - 1) * FONT_CHAR_WIDTH,DISPLAY_LSM303ACC_ID_HIGHT,(const char *)temp_buffer,BLACK);

  lcd.drawString(0,DISPLAY_LSM303MAG_ID_HIGHT,DISPLAY_LSM303MAG_ID_STRING,RED);
  translateBinaryToBCD(temp_buffer,iks102.getIdLSM303MAG());
  lcd.drawString((sizeof(DISPLAY_LSM303MAG_ID_STRING) - 1) * FONT_CHAR_WIDTH,DISPLAY_LSM303MAG_ID_HIGHT,(const char *)temp_buffer,BLACK);

  lcd.drawString(0,DISPLAY_HTS221_ID_HIGHT,DISPLAY_HTS221_ID_STRING,RED);
  translateBinaryToBCD(temp_buffer,iks102.getIdHTS221());
  lcd.drawString((sizeof(DISPLAY_HTS221_ID_STRING) - 1) * FONT_CHAR_WIDTH,DISPLAY_HTS221_ID_HIGHT,(const char *)temp_buffer,BLACK);

  lcd.drawString(0,DISPLAY_LPS22_ID_HIGHT,DISPLAY_LPS22_ID_STRING,RED);
  translateBinaryToBCD(temp_buffer,iks102.getIdLPS22HB());
  lcd.drawString((sizeof(DISPLAY_LPS22_ID_STRING) - 1) * FONT_CHAR_WIDTH,DISPLAY_LPS22_ID_HIGHT,(const char *)temp_buffer,BLACK);
  /*Set LSM6DSL for LCD string*/
  lcd.drawString(0,DISPLAY_LSM6DSL_ACC_VALUE_STRING_HIGHT,DISPLAY_LSM6DSL_ACC_VALUE_STRING,RED);
  lcd.drawString(0,DISPLAY_LSM6DSL_MAG_VALUE_STRING_HIGHT,DISPLAY_LSM6DSL_MAG_VALUE_STRING,RED);

  lcd.drawString(0,DISPLAY_LSM303AGR_ACC_VALUE_STRING_HIGH,DISPLAY_LSM303AGR_ACC_VALUE_STRING,RED);
  lcd.drawString(0,DISPLAY_LSM303MAG_VALUE_STRING_HIGH,DISPLAY_LSM303MAG_VALUE_STRING,RED);
  lcd.drawString(0,DISPLAY_HTS221_VALUE_STRING_HIGH,DISPLAY_HTS221_VALUE_STRING,RED);
  lcd.drawString(0,DISPLAY_LPS22HB_VALUE_STRING_HIGH,DISPLAY_LPS22HB_VALUE_STRING,RED);
#endif
}

static void handleLCDForIKS102(LCD &lcd,IKS01A2 &iks102)
{
  int32_t accelerometer[3];
  char temp_buffer[50];
  float humidity,temperature,pressure;
  //display for IKS102
  //display Img
  while(1)
  {
     /*Display LSM6DSL ACC*/
     memset(temp_buffer,0,sizeof(temp_buffer));
     iks102.getXAxesLSM6DSL(accelerometer);
     sprintf(temp_buffer,"%d,%d,%d",accelerometer[0],accelerometer[1],accelerometer[2]);
     printf("LSM6DSL X Axes = %d , %d , %d\r\n",accelerometer[0],accelerometer[1],accelerometer[2]);
#ifdef TEST_LCD
     lcd.drawString(0,DISPLAY_LSM6DSL_ACC_VALUE_HIGHT,temp_buffer,RED);
#endif
     
      /*Display LSM6DSL MAG*/
     memset(temp_buffer,0,sizeof(temp_buffer));
     iks102.getGAxesLSM6DSL(accelerometer);
     sprintf(temp_buffer,"%d,%d,%d",accelerometer[0],accelerometer[1],accelerometer[2]);
     printf("LSM6DSL G Axes = %d , %d , %d\r\n",accelerometer[0],accelerometer[1],accelerometer[2]);
#ifdef TEST_LCD
     lcd.drawString(0,DISPLAY_LSM6DSL_MAG_VALUE_HIGHT,temp_buffer,RED);
#endif
   
     /*Display LSM303AGR_ACC*/
     memset(temp_buffer,0,sizeof(temp_buffer));
     iks102.getDataLSM303AGR(accelerometer);
     sprintf(temp_buffer,"%d,%d,%d",accelerometer[0],accelerometer[1],accelerometer[2]);
     printf("LSM303AGR [acc/mg] = %d , %d , %d\r\n",accelerometer[0],accelerometer[1],accelerometer[2]);
#ifdef TEST_LCD
     lcd.drawString(0,DISPLAY_LSM303AGR_ACC_VALUE_HIGH,temp_buffer,RED);
#endif
    
     /*Display LSM303AGR_MAG*/
     memset(temp_buffer,0,sizeof(temp_buffer));
     iks102.getDataLSM303MAG(accelerometer);
     sprintf(temp_buffer,"%d,%d,%d",accelerometer[0],accelerometer[1],accelerometer[2]);
     printf("LSM303MAG [mag/mgauss] = %d , %d , %d\r\n",accelerometer[0],accelerometer[1],accelerometer[2]);
#ifdef TEST_LCD
     lcd.drawString(0,DISPLAY_LSM303MAG_VALUE_HIGH,temp_buffer,RED);
#endif
     
     /*Display HTS221*/
     memset(temp_buffer,0,sizeof(temp_buffer));
     iks102.GetHumidity(&humidity);
     sprintf(temp_buffer,"humidity %d,",(int)humidity);
     iks102.GetTemperatureHTS221(&temperature);
     sprintf(temp_buffer + strlen(temp_buffer),"temperature %d",(int)temperature);
     printf("HTS221Sensor humidity = %f,temperature = %f \r\n",humidity,temperature);
#ifdef TEST_LCD
     lcd.drawString(0,DISPLAY_HTS221_VALUE_HIGH,temp_buffer,RED);
#endif
     
     /*Display LPS22HB*/
     memset(temp_buffer,0,sizeof(temp_buffer));
     iks102.GetPressure(&humidity);
     sprintf(temp_buffer,"pressure %d,",(int)humidity);
     iks102.GetTemperatureLPS22HB(&temperature);
     sprintf(temp_buffer + strlen(temp_buffer),"temperature %d",(int)temperature);
     printf("LPS22HBSensor pressure = %f, temperature = %f \r\n",pressure,temperature);
#ifdef TEST_LCD
     lcd.drawString(0,DISPLAY_LPS22HB_VALUE_HIGH,temp_buffer,RED);
#endif
     //add log
     wait_ms(1000);
#ifdef TEST_LCD
     lcd.clearScreenArea(0,DISPLAY_LSM6DSL_ACC_VALUE_HIGHT,WHITE);
     lcd.clearScreenArea(0,DISPLAY_LSM6DSL_MAG_VALUE_HIGHT,WHITE);
     lcd.clearScreenArea(0,DISPLAY_LSM303AGR_ACC_VALUE_HIGH,WHITE);
     lcd.clearScreenArea(0,DISPLAY_LSM303MAG_VALUE_HIGH,WHITE);
     lcd.clearScreenArea(0,DISPLAY_HTS221_VALUE_HIGH,WHITE);
     lcd.clearScreenArea(0,DISPLAY_LPS22HB_VALUE_HIGH,WHITE);
#endif
  }
}



int main()
{
     int32_t accelerometer[3];
     float humidity,temperature;
     float pressure;
     printf("%s\r\n",DISPLAY_TMPM_STRING);
     I2C *i2c =new I2C(D14,D15);
     LSM6DSLSensor *lsm = new LSM6DSLSensor(i2c,LSM6DSL_ACC_GYRO_I2C_ADDRESS_HIGH);
     LSM303AGR_ACC_Sensor *Acc = new LSM303AGR_ACC_Sensor(i2c);
     LSM303AGR_MAG_Sensor *Mag = new LSM303AGR_MAG_Sensor(i2c);

     HTS221Sensor *HumTemp = new HTS221Sensor (i2c);  
     LPS22HBSensor *PressTemp = new LPS22HBSensor(i2c);  
     uint8_t temp_id;
     lsm->ReadID(&temp_id);
     // 
     lsm->Enable_X();  
     lsm->Enable_G(); 
     //
     Acc->Enable();
     Mag->Enable(); 

     HumTemp->Enable();
     PressTemp->Enable();
     printf("LSM6DSLSensor ID = 0x%x \r\n",temp_id);

     Acc->ReadID(&temp_id);
     printf("LSM303AGR_ACC_Sensor ID = 0x%x \r\n",temp_id);
     Mag->ReadID(&temp_id);
     printf("LSM303AGR_MAG_Sensor ID = 0x%x \r\n",temp_id);
     HumTemp->ReadID(&temp_id);
     printf("HTS221Sensor ID = 0x%x \r\n",temp_id);
     PressTemp->ReadID(&temp_id);
     printf("LPS22HBSensor ID = 0x%x \r\n",temp_id);
    
     IKS01A2 iks102(i2c);
#ifdef TEST_LCD
     tft.init();
#endif
     displayForIKS01A2(tft,iks102);
     handleLCDForIKS102(tft,iks102);
     while(1)
     {
     }
        
}